/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.local.zip.tozip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class AddDirToZipTask
extends Task {
    private static final String taskName = "AddDirToZip";
    private File targetZipFileDir;
    private final List<File> sourceDirsToAdd;
    private final boolean forceExcludedDirs;
    private final boolean createRootDirInTargetZIP;

    public AddDirToZipTask(List<File> sourceDirsToAdd, File targetZipFile, boolean createRootDirInTargetZIP, boolean forceExcludedDirs, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.targetZipFileDir = targetZipFile;
        this.sourceDirsToAdd = sourceDirsToAdd;
        this.sender = sender;
        this.forceExcludedDirs = forceExcludedDirs;
        this.createRootDirInTargetZIP = createRootDirInTargetZIP;
    }

    @Override
    public void run() {
        if (this.setLocked) {
            Backuper.lock(this);
        }
        try {
            Logger.getLogger().devLog("AddDirToZip task has been started");
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            if (this.targetZipFileDir != null && !this.targetZipFileDir.exists() && !this.targetZipFileDir.createNewFile()) {
                Logger.getLogger().devLog("Failed to create file " + this.targetZipFileDir.getAbsolutePath());
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.targetZipFileDir));){
                for (File sourceDirToAdd : this.sourceDirsToAdd) {
                    if (this.cancelled) {
                        break;
                    }
                    if (this.createRootDirInTargetZIP) {
                        this.addDirToZip(zipOutputStream, sourceDirToAdd, sourceDirToAdd.getParentFile().toPath());
                        continue;
                    }
                    this.addDirToZip(zipOutputStream, sourceDirToAdd, sourceDirToAdd.toPath());
                }
            }
            catch (Exception e) {
                Logger.getLogger().warn("AddDirToZip task failed", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
                Backuper.unlock();
            }
            Logger.getLogger().devLog("AddDirToZip task has been finished");
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong while running AddDirToZip task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    private void addDirToZip(ZipOutputStream zip, File sourceDir, Path relativeDirPath) {
        if (this.cancelled) {
            return;
        }
        if (!sourceDir.exists()) {
            Logger.getLogger().warn("Something went wrong while running AddDirToZIP task", this.sender);
            Logger.getLogger().warn("Directory " + sourceDir.getAbsolutePath() + " does not exist", this.sender);
            return;
        }
        boolean isExcludedDirectory = Utils.isExcludedDirectory(sourceDir, this.sender);
        if (isExcludedDirectory && !this.forceExcludedDirs) {
            return;
        }
        if (!this.cancelled && sourceDir.isFile()) {
            try {
                int length;
                String relativeFilePath = relativeDirPath.toAbsolutePath().relativize(sourceDir.toPath().toAbsolutePath()).toString();
                zip.setLevel(Config.getInstance().getLocalConfig().getZipCompressionLevel());
                ZipEntry zipEntry = new ZipEntry(relativeFilePath);
                zip.putNextEntry(zipEntry);
                FileInputStream fileInputStream = new FileInputStream(sourceDir);
                byte[] buffer = new byte[4048];
                while ((length = fileInputStream.read(buffer)) >= 0 && !this.cancelled) {
                    zip.write(buffer, 0, length);
                    this.incrementCurrentProgress(length);
                }
                zip.closeEntry();
                fileInputStream.close();
            }
            catch (Exception e) {
                Logger.getLogger().warn("Something went wrong while running AddDirToZIP task", this.sender);
                Logger.getLogger().warn("Something went wrong while trying to put file in ZIP! " + sourceDir.getName(), this.sender);
                Logger.getLogger().warn(this.getClass(), e);
            }
        }
        if (sourceDir.listFiles() == null) {
            return;
        }
        for (File file : sourceDir.listFiles()) {
            if (file.getName().equals("session.lock")) continue;
            this.addDirToZip(zip, file, relativeDirPath);
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        if (!this.forceExcludedDirs) {
            for (File sourceDirToAdd : this.sourceDirsToAdd) {
                this.maxProgress += Utils.getFileFolderByteSizeExceptExcluded(sourceDirToAdd);
            }
        } else {
            for (File sourceDirToAdd : this.sourceDirsToAdd) {
                this.maxProgress += Utils.getFileFolderByteSize(sourceDirToAdd);
            }
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }
}

