/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.local.zip.tozip;

import java.io.File;
import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.local.folder.DeleteDirTask;
import ru.dvdishka.backuper.backend.tasks.local.zip.tozip.AddDirToZipTask;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class ConvertFolderToZipTask
extends Task {
    private static final String taskName = "ToZip";
    private final File sourceFolderDir;
    private AddDirToZipTask addDirToZipTask;
    private DeleteDirTask deleteDirTask;
    private final long deleteProgressMultiplier = 1L;
    private final long zipProgressMultiplier = 10L;

    public ConvertFolderToZipTask(File sourceFolderDir, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.sourceFolderDir = sourceFolderDir;
    }

    @Override
    public void run() {
        if (this.setLocked) {
            Backuper.lock(this);
        }
        try {
            Logger.getLogger().devLog("ToZip task has been started");
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            if (!this.cancelled) {
                this.addDirToZipTask.run();
            }
            if (!this.cancelled) {
                this.deleteDirTask.run();
            }
            if (!this.cancelled) {
                Logger.getLogger().devLog("The Rename \"in progress\" Folder/ZIP local task has been started");
                if (!new File(this.sourceFolderDir.getPath() + " in progress.zip").renameTo(new File(this.sourceFolderDir.getPath() + ".zip"))) {
                    Logger.getLogger().warn("The Rename \"in progress\" ZIP local task has been finished with an exception!", this.sender);
                }
                Logger.getLogger().devLog("The Rename \"in progress\" Folder/ZIP local task has been finished");
            }
            Logger.getLogger().devLog("FolderToZip task has been finished");
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong while running FolderToZip task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        this.addDirToZipTask = new AddDirToZipTask(List.of(this.sourceFolderDir), new File(this.sourceFolderDir.getPath() + " in progress.zip"), false, true, false, this.permissions, this.sender);
        this.addDirToZipTask.prepareTask();
        this.deleteDirTask = new DeleteDirTask(this.sourceFolderDir, false, (List<Permissions>)this.permissions, this.sender);
        this.deleteDirTask.prepareTask();
    }

    @Override
    public long getTaskCurrentProgress() {
        if (this.addDirToZipTask == null || this.deleteDirTask == null) {
            return 0L;
        }
        return this.addDirToZipTask.getTaskCurrentProgress() * 10L + this.deleteDirTask.getTaskCurrentProgress() * 1L;
    }

    @Override
    public long getTaskMaxProgress() {
        if (this.addDirToZipTask == null || this.deleteDirTask == null) {
            return 100L;
        }
        return this.addDirToZipTask.getTaskMaxProgress() * 10L + this.deleteDirTask.getTaskMaxProgress() * 1L;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.deleteDirTask.cancel();
        this.addDirToZipTask.cancel();
    }
}

