/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.local.zip.unzip;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class UnpackZipTask
extends Task {
    private static final String taskName = "UnpackZip";
    private final File sourceZipDir;
    private final File targetFolderDir;

    public UnpackZipTask(File sourceZipDir, File targetFolderDir, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.sourceZipDir = sourceZipDir;
        this.targetFolderDir = targetFolderDir;
    }

    @Override
    public void run() {
        if (this.setLocked) {
            Backuper.lock(this);
        }
        try (ZipInputStream zipInput = new ZipInputStream(Files.newInputStream(this.sourceZipDir.toPath(), new OpenOption[0]));){
            ZipEntry zipEntry;
            Logger.getLogger().devLog("UnpackZip task has been started");
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            while (!this.cancelled && (zipEntry = zipInput.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    this.targetFolderDir.mkdirs();
                    zipInput.closeEntry();
                    continue;
                }
                String name = zipEntry.getName();
                try {
                    if (!this.targetFolderDir.toPath().resolve(name).getParent().toFile().exists()) {
                        this.targetFolderDir.toPath().resolve(name).getParent().toFile().mkdirs();
                    }
                    try (FileOutputStream outputStream = new FileOutputStream(this.targetFolderDir.toPath().resolve(name).toFile());){
                        int length;
                        byte[] buffer = new byte[4096];
                        while ((length = zipInput.read(buffer)) >= 0 && !this.cancelled) {
                            outputStream.write(buffer, 0, length);
                            this.incrementCurrentProgress(length);
                        }
                        outputStream.flush();
                    }
                }
                catch (Exception e) {
                    Logger.getLogger().warn("Something went wrong while trying to unpack file", this.sender);
                    Logger.getLogger().warn(this.getClass(), e);
                }
                zipInput.closeEntry();
            }
            Logger.getLogger().devLog("UnpackZip task has been finished");
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong while running UnpackZip task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        this.maxProgress = 0L;
        try (ZipFile zipFile = new ZipFile(this.sourceZipDir);){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                if (this.cancelled) {
                    break;
                }
                ZipEntry zipEntry = zipEntries.nextElement();
                this.maxProgress += zipEntry.getSize();
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Something went wrong while calculating UnpackZip task maxProgress", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
        if (this.maxProgress <= 0L) {
            this.maxProgress = (long)((double)Utils.getFileFolderByteSize(this.sourceZipDir) * 1.6);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }
}

