/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.utils.SftpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class SftpDeleteDirTask
extends Task {
    private static final String taskName = "SftpDeleteDir";
    private String remoteDirToDelete = "";
    Session session = null;
    ChannelSftp channelSftp = null;

    public SftpDeleteDirTask(String remoteDirToDelete, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.remoteDirToDelete = remoteDirToDelete;
    }

    @Override
    public void run() {
        try {
            if (this.setLocked) {
                Backuper.lock(this);
            }
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            Logger.getLogger().devLog("SftpDeleteDir task has been started");
            if (!this.cancelled) {
                Pair<Session, ChannelSftp> sessionChannelSftpPair = SftpUtils.createChannel(this.sender);
                if (sessionChannelSftpPair == null) {
                    return;
                }
                this.session = sessionChannelSftpPair.getLeft();
                this.channelSftp = sessionChannelSftpPair.getRight();
                this.channelSftp.connect(10000);
            }
            if (!this.cancelled) {
                this.deleteDir(this.remoteDirToDelete);
            }
            if (this.setLocked) {
                Backuper.unlock();
                UIUtils.successSound(this.sender);
            }
        }
        catch (Exception e) {
            if (this.setLocked) {
                Backuper.unlock();
                UIUtils.cancelSound(this.sender);
            }
            Logger.getLogger().warn("Something went wrong when trying to execute SftpDeleteDir task", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
        finally {
            try {
                this.session.disconnect();
            }
            catch (Exception exception) {}
            try {
                this.channelSftp.exit();
            }
            catch (Exception exception) {}
            Logger.getLogger().devLog("SftpDeleteDir task has been finished");
        }
    }

    @Override
    public void prepareTask() {
        this.maxProgress = SftpUtils.getDirByteSize(this.remoteDirToDelete, this.sender);
        this.isTaskPrepared = true;
    }

    private void deleteDir(String remoteDirToDelete) {
        if (this.cancelled) {
            return;
        }
        try {
            SftpATTRS stat = this.channelSftp.stat(remoteDirToDelete);
            if (stat.isDir()) {
                Vector<ChannelSftp.LsEntry> ls = this.channelSftp.ls(remoteDirToDelete);
                for (ChannelSftp.LsEntry file : ls) {
                    if (file.getFilename().equals(".") || file.getFilename().equals("..")) continue;
                    this.deleteDir(SftpUtils.resolve(remoteDirToDelete, file.getFilename()));
                }
                this.channelSftp.rmdir(remoteDirToDelete);
            } else {
                long fileSize = stat.getSize();
                this.channelSftp.rm(remoteDirToDelete);
                this.incrementCurrentProgress(fileSize);
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Something went while trying to delete SFTP directory", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }
}

