/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.sftp.SftpProgressMonitor;
import ru.dvdishka.backuper.backend.utils.SftpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class SftpGetFileFolderTask
extends Task {
    private static final String taskName = "SftpGetFileFolder";
    private String remotePathToGet = "";
    private File localTargetPathFile;
    private boolean createRootDirInTargetDir = false;
    private Session session = null;
    private ChannelSftp sftpChannel = null;
    private long dirSize = 0L;
    private ArrayList<CompletableFuture<Void>> sftpTasks = new ArrayList();
    private ArrayList<SftpProgressMonitor> progressMonitors = new ArrayList();

    public SftpGetFileFolderTask(String remotePathToGet, File localTargetPathFile, boolean createRootDirInTargetDir, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.remotePathToGet = remotePathToGet;
        this.localTargetPathFile = localTargetPathFile;
        this.createRootDirInTargetDir = createRootDirInTargetDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.setLocked) {
                Backuper.lock(this);
            }
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            Logger.getLogger().devLog("SftpGetFileFolder task has been started");
            if (!this.cancelled) {
                Pair<Session, ChannelSftp> sessionChannelSftpPair = SftpUtils.createChannel(this.sender);
                if (sessionChannelSftpPair == null) {
                    return;
                }
                this.session = sessionChannelSftpPair.getLeft();
                this.sftpChannel = sessionChannelSftpPair.getRight();
                this.sftpChannel.connect(10000);
            }
            if (this.createRootDirInTargetDir) {
                Object remoteDirName = "";
                for (char c : this.remotePathToGet.toCharArray()) {
                    String symbol = String.valueOf(c);
                    remoteDirName = Objects.equals(symbol, Config.getInstance().getSftpConfig().getPathSeparatorSymbol()) ? "" : (String)remoteDirName + symbol;
                }
                this.localTargetPathFile = this.localTargetPathFile.toPath().resolve((String)remoteDirName).toFile();
            }
            if (!this.cancelled) {
                this.getRemoteDir(this.remotePathToGet, this.localTargetPathFile);
            }
            try {
                this.sftpChannel.exit();
                this.session.disconnect();
            }
            catch (Exception remoteDirName) {
                // empty catch block
            }
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (Exception e) {
            try {
                this.sftpChannel.exit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.session.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong when trying to get file from the SFTP channel", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
        finally {
            Logger.getLogger().devLog("SftpGetFileFolder task has been finished");
        }
    }

    @Override
    public void prepareTask() {
        this.dirSize = SftpUtils.getDirByteSize(this.remotePathToGet, this.sender);
    }

    private void getRemoteDir(String remotePath, File localPath) {
        if (this.cancelled) {
            return;
        }
        try {
            SftpATTRS remoteAttrs = this.sftpChannel.stat(remotePath);
            if (!remoteAttrs.isDir()) {
                localPath.createNewFile();
                SftpProgressMonitor progressMonitor = new SftpProgressMonitor();
                this.progressMonitors.add(progressMonitor);
                CompletableFuture<Void> task = CompletableFuture.runAsync(() -> {
                    try {
                        this.sftpChannel.get(remotePath, localPath.getCanonicalPath(), (com.jcraft.jsch.SftpProgressMonitor)progressMonitor);
                    }
                    catch (Exception e) {
                        Logger.getLogger().devWarn(this.getClass(), "Something went wrong when trying to download file \"" + remotePath + "\" from SFTP server");
                        Logger.getLogger().devWarn(this.getClass(), Arrays.toString(e.getStackTrace()));
                    }
                });
                this.sftpTasks.add(task);
                try {
                    task.join();
                }
                catch (Exception e) {
                    if (!this.cancelled) {
                        Logger.getLogger().warn("Something went wrong when trying to download file \"" + remotePath + "\" from SFTP server", this.sender);
                        Logger.getLogger().warn(this.getClass(), e);
                    }
                }
            } else {
                localPath.mkdirs();
                for (ChannelSftp.LsEntry entry : this.sftpChannel.ls(remotePath)) {
                    if (entry.getFilename().equals(".") || entry.getFilename().equals("..")) continue;
                    this.getRemoteDir(SftpUtils.resolve(remotePath, entry.getFilename()), localPath.toPath().resolve(entry.getFilename()).toFile());
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger().warn("Failed to get file/folder from the SFTP channel", this.sender);
            Logger.getLogger().warn(this.getClass(), e);
        }
    }

    @Override
    public long getTaskCurrentProgress() {
        if (this.cancelled) {
            return this.dirSize;
        }
        long currentProgress = 0L;
        for (SftpProgressMonitor progressMonitor : this.progressMonitors) {
            currentProgress += progressMonitor.getCurrentProgress();
        }
        return currentProgress;
    }

    @Override
    public long getTaskMaxProgress() {
        return this.dirSize;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (CompletableFuture<Void> task : this.sftpTasks) {
            task.cancel(true);
        }
    }
}

