/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.tasks.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.sftp.SftpProgressMonitor;
import ru.dvdishka.backuper.backend.utils.SftpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Permissions;

public class SftpSendFileFolderTask
extends Task {
    private static final String taskName = "SftpSendFileFolder";
    private File localDirToSend;
    private boolean createRootDirInTargetDir;
    private String remoteTargetDir = "";
    private boolean forceExcludedDirs = false;
    private Session sshSession;
    private ChannelSftp sftpChannel;
    private ArrayList<CompletableFuture<Void>> sftpTasks = new ArrayList();
    private ArrayList<SftpProgressMonitor> progressMonitors = null;
    private long dirSize = 0L;

    public SftpSendFileFolderTask(File localDirToSend, String remoteTargetDir, boolean createRootDirInTargetDir, boolean forceExcludedDirs, boolean setLocked, List<Permissions> permission, CommandSender sender) {
        super(taskName, setLocked, permission, sender);
        this.localDirToSend = localDirToSend;
        this.createRootDirInTargetDir = createRootDirInTargetDir;
        this.remoteTargetDir = remoteTargetDir;
        this.forceExcludedDirs = forceExcludedDirs;
    }

    @Override
    public void run() {
        try {
            if (this.setLocked) {
                Backuper.lock(this);
            }
            if (!this.isTaskPrepared) {
                this.prepareTask();
            }
            Logger.getLogger().devLog("SftpSendFileFolder task has been started");
            if (!this.cancelled) {
                Pair<Session, ChannelSftp> sessionChannelSftpPair = SftpUtils.createChannel(this.sender);
                if (sessionChannelSftpPair == null) {
                    return;
                }
                this.sshSession = sessionChannelSftpPair.getLeft();
                this.sftpChannel = sessionChannelSftpPair.getRight();
                if (this.sftpChannel == null) {
                    return;
                }
                this.sftpChannel.connect(10000);
            }
            if (this.createRootDirInTargetDir) {
                this.remoteTargetDir = SftpUtils.resolve(this.remoteTargetDir, this.localDirToSend.getName());
            }
            this.progressMonitors = new ArrayList();
            if (!this.cancelled) {
                this.sendFolder(this.localDirToSend, this.remoteTargetDir);
            }
            this.sftpChannel.exit();
            this.sshSession.disconnect();
            if (this.setLocked) {
                UIUtils.successSound(this.sender);
                Backuper.unlock();
            }
        }
        catch (JSchException e) {
            try {
                this.sftpChannel.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.sshSession.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.setLocked) {
                UIUtils.cancelSound(this.sender);
                Backuper.unlock();
            }
            Logger.getLogger().warn("Something went wrong when trying to send file/folder through the SFTP channel", this.sender);
            Logger.getLogger().warn(this.getClass(), (Exception)e);
        }
        finally {
            Logger.getLogger().devLog("SftpSendFileFolder task has been finished");
        }
    }

    @Override
    public void prepareTask() {
        this.isTaskPrepared = true;
        this.dirSize = this.forceExcludedDirs ? Utils.getFileFolderByteSize(this.localDirToSend) : Utils.getFileFolderByteSizeExceptExcluded(this.localDirToSend);
    }

    private void sendFolder(File localDirToSend, String remotePath) {
        if (this.cancelled) {
            return;
        }
        if (!localDirToSend.exists()) {
            Logger.getLogger().warn("Something went wrong while trying to send files from " + localDirToSend.getAbsolutePath());
            Logger.getLogger().warn("Directory " + localDirToSend.getAbsolutePath() + " does not exist", this.sender);
            return;
        }
        boolean isExcludedDirectory = Utils.isExcludedDirectory(localDirToSend, this.sender);
        if (isExcludedDirectory && !this.forceExcludedDirs) {
            return;
        }
        if (localDirToSend.isFile() && !localDirToSend.getName().equals("session.lock")) {
            try {
                String localPath = localDirToSend.getCanonicalPath();
                SftpProgressMonitor progressMonitor = new SftpProgressMonitor();
                this.progressMonitors.add(progressMonitor);
                CompletableFuture<Void> task = CompletableFuture.runAsync(() -> {
                    try {
                        this.sftpChannel.put(localPath, remotePath, (com.jcraft.jsch.SftpProgressMonitor)progressMonitor);
                    }
                    catch (Exception e) {
                        Logger.getLogger().devWarn(this.getClass(), "Failed to send file \"" + localPath + "\" using SFTP connection");
                        Logger.getLogger().devWarn(this.getClass(), Arrays.toString(e.getStackTrace()));
                    }
                });
                this.sftpTasks.add(task);
                try {
                    task.join();
                }
                catch (Exception e) {
                    if (!this.cancelled) {
                        Logger.getLogger().warn("Failed to send file \"" + localPath + "\" using SFTP connection", this.sender);
                        Logger.getLogger().warn(this.getClass(), e);
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger().warn("Something went wrong while sending file to the SFTP channel", this.sender);
                Logger.getLogger().warn(this.getClass(), e);
            }
        }
        if (localDirToSend.isDirectory() && localDirToSend.listFiles() != null) {
            try {
                this.sftpChannel.mkdir(remotePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (File file : localDirToSend.listFiles()) {
                this.sendFolder(file, SftpUtils.resolve(remotePath, file.getName()));
            }
        }
    }

    @Override
    public long getTaskCurrentProgress() {
        if (this.cancelled) {
            return this.maxProgress;
        }
        if (this.progressMonitors == null) {
            return 0L;
        }
        long currentProgress = 0L;
        for (SftpProgressMonitor progressMonitor : this.progressMonitors) {
            currentProgress += progressMonitor.getCurrentProgress();
        }
        return currentProgress;
    }

    @Override
    public long getTaskMaxProgress() {
        return this.dirSize;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (CompletableFuture<Void> sftpTask : this.sftpTasks) {
            sftpTask.cancel(true);
        }
    }
}

