/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.backup;

import com.google.common.primitives.Longs;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.common.Logger;
import ru.dvdishka.backuper.backend.common.Scheduler;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.common.BackupTask;
import ru.dvdishka.backuper.backend.utils.FtpUtils;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.backend.utils.SftpUtils;
import ru.dvdishka.backuper.backend.utils.UIUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.Permissions;
import ru.dvdishka.backuper.handlers.commands.task.status.StatusCommand;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class BackupCommand
extends Command {
    private String afterBackup = "NOTHING";
    private long delay;
    private boolean isLocal = false;
    private boolean isFtp = false;
    private boolean isSftp = false;
    private boolean isGoogleDrive = false;

    public BackupCommand(CommandSender sender, CommandArguments args, String afterBackup) {
        super(sender, args);
        String[] storages;
        this.afterBackup = afterBackup;
        this.delay = (Long)args.getOrDefault("delaySeconds", (Object)1L);
        String storageString = (String)args.get("storage");
        for (String s2 : storages = storageString.split("-")) {
            if (s2.equals("local")) {
                this.isLocal = true;
            }
            if (s2.equals("ftp")) {
                this.isFtp = true;
            }
            if (s2.equals("sftp")) {
                this.isSftp = true;
            }
            if (!s2.equals("googleDrive")) continue;
            this.isGoogleDrive = true;
        }
    }

    public BackupCommand(CommandSender sender, CommandArguments args) {
        super(sender, args);
        String[] storages;
        this.delay = (Long)args.getOrDefault("delaySeconds", (Object)1L);
        String storageString = (String)args.get("storage");
        for (String s2 : storages = storageString.split("-")) {
            if (s2.equals("local")) {
                this.isLocal = true;
            }
            if (s2.equals("ftp")) {
                this.isFtp = true;
            }
            if (s2.equals("sftp")) {
                this.isSftp = true;
            }
            if (!s2.equals("googleDrive")) continue;
            this.isGoogleDrive = true;
        }
    }

    @Override
    public void execute() {
        if (Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("Blocked by another operation!");
            return;
        }
        if (this.delay < 1L) {
            this.cancelSound();
            this.returnFailure("Delay must be > 0!");
            return;
        }
        if (!(this.isLocal || this.isFtp || this.isSftp || this.isGoogleDrive)) {
            this.cancelSound();
            this.returnFailure("Wrong storage types!");
            return;
        }
        if (this.isLocal && !Config.getInstance().getLocalConfig().isEnabled()) {
            this.cancelSound();
            this.returnFailure("Local storage is disabled!");
            return;
        }
        if (this.isFtp && !FtpUtils.checkConnection(this.sender)) {
            this.cancelSound();
            this.returnFailure("FTP(S) storage is disabled or unavailable!");
            return;
        }
        if (this.isSftp && !SftpUtils.checkConnection(this.sender)) {
            this.cancelSound();
            this.returnFailure("SFTP storage is disabled or unavailable!");
            return;
        }
        if (!(!this.isGoogleDrive || Config.getInstance().getGoogleDriveConfig().isEnabled() && GoogleDriveUtils.isAuthorized(this.sender))) {
            this.cancelSound();
            this.returnFailure("Google Drive storage is disabled or account is not linked!");
            return;
        }
        this.buttonSound();
        if (Config.getInstance().getAlertTimeBeforeRestart() != -1L) {
            Scheduler.getScheduler().runSyncDelayed(Utils.plugin, () -> UIUtils.sendBackupAlert(Longs.min(Config.getInstance().getAlertTimeBeforeRestart(), this.delay), this.afterBackup), Math.max((this.delay - Config.getInstance().getAlertTimeBeforeRestart()) * 20L, 1L));
        }
        ArrayList<Permissions> backupPermissions = new ArrayList<Permissions>();
        backupPermissions.add(Permissions.BACKUP);
        if (this.afterBackup.equals("STOP")) {
            backupPermissions.add(Permissions.STOP);
        }
        if (this.afterBackup.equals("RESTART")) {
            backupPermissions.add(Permissions.RESTART);
        }
        Scheduler.getScheduler().runSyncDelayed(Utils.plugin, () -> {
            StatusCommand.sendTaskStartedMessage("Backup", this.sender);
            Scheduler.getScheduler().runAsync(Utils.plugin, () -> {
                new BackupTask(this.afterBackup, false, this.isLocal, this.isFtp, this.isSftp, this.isGoogleDrive, true, backupPermissions, this.sender).run();
                this.sendMessage("Backup task completed");
            });
        }, this.delay * 20L);
        if (this.arguments.get("delaySeconds") != null) {
            this.returnSuccess("Backup task will be started in " + this.delay + " seconds");
            if (!(this.sender instanceof ConsoleCommandSender)) {
                Logger.getLogger().log("Backup task will be started in " + this.delay + " seconds");
            }
        }
    }
}

