/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import ru.dvdishka.backuper.backend.backup.ExternalBackup;
import ru.dvdishka.backuper.backend.backup.FtpBackup;
import ru.dvdishka.backuper.backend.backup.GoogleDriveBackup;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.backup.SftpBackup;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class MenuCommand
extends Command {
    private String storage = "";

    public MenuCommand(String storage, CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
        this.storage = storage;
    }

    @Override
    public void execute() {
        String backupName = (String)this.arguments.get("backupName");
        if (this.storage.equals("local") && !Config.getInstance().getLocalConfig().isEnabled() || this.storage.equals("sftp") && !Config.getInstance().getSftpConfig().isEnabled() || this.storage.equals("ftp") && !Config.getInstance().getFtpConfig().isEnabled() || this.storage.equals("googleDrive") && (!Config.getInstance().getGoogleDriveConfig().isEnabled() || !GoogleDriveUtils.isAuthorized(this.sender))) {
            this.cancelSound();
            if (!this.storage.equals("googleDrive")) {
                this.returnFailure(this.storage + " storage is disabled!");
            } else {
                this.returnFailure(this.storage + " storage is disabled or Google account is not linked!");
            }
            return;
        }
        if (this.storage.equals("local") && !LocalBackup.checkBackupExistenceByName(backupName) || this.storage.equals("sftp") && !SftpBackup.checkBackupExistenceByName(backupName) || this.storage.equals("ftp") && !FtpBackup.checkBackupExistenceByName(backupName) || this.storage.equals("googleDrive") && !GoogleDriveBackup.checkBackupExistenceByName(backupName)) {
            this.cancelSound();
            this.returnFailure("Backup does not exist!");
            return;
        }
        assert (backupName != null);
        this.buttonSound();
        ExternalBackup backup = null;
        if (this.storage.equals("local")) {
            backup = LocalBackup.getInstance(backupName);
        }
        if (this.storage.equals("sftp")) {
            backup = SftpBackup.getInstance(backupName);
        }
        if (this.storage.equals("ftp")) {
            backup = FtpBackup.getInstance(backupName);
        }
        if (this.storage.equals("googleDrive")) {
            backup = GoogleDriveBackup.getInstance(backupName);
        }
        String backupFormattedName = backup.getFormattedName();
        long backupMbSize = backup.getMbSize(this.sender);
        String zipOrFolder = backup.getFileType();
        TextComponent header = Component.empty();
        header = header.append(Component.text((String)"Backup menu").decorate(TextDecoration.BOLD)).append((Component)Component.space()).append(((TextComponent)Component.text((String)("(" + this.storage + ")")).color(TextColor.fromHexString((String)"#129c9b"))).decorate(TextDecoration.BOLD));
        TextComponent message = Component.empty();
        if (!(this.sender instanceof ConsoleCommandSender)) {
            message = message.append(Component.text((String)backupFormattedName).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("(" + this.storage + ") " + zipOrFolder + " " + backupMbSize + " MB"))))).append((Component)Component.newline()).append((Component)Component.newline());
            if (this.storage.equals("local") && backup.getFileType().equals("(Folder)")) {
                message = message.append(((TextComponent)((TextComponent)Component.text((String)"[TO ZIP]").clickEvent(ClickEvent.runCommand((String)("/backuper menu " + this.storage + " \"" + backupName + "\" toZIPConfirmation")))).decorate(TextDecoration.BOLD)).color(TextColor.color((int)300875))).append((Component)Component.space());
            }
            if (this.storage.equals("local") && backup.getFileType().equals("(ZIP)")) {
                message = message.append(((TextComponent)((TextComponent)Component.text((String)"[UNZIP]").clickEvent(ClickEvent.runCommand((String)("/backuper menu " + this.storage + " \"" + backupName + "\" unZIPConfirmation")))).decorate(TextDecoration.BOLD)).color(TextColor.color((int)300875))).append((Component)Component.space());
            }
            if (this.storage.equals("local") && Config.getInstance().getFtpConfig().isEnabled()) {
                message = message.append(((TextComponent)((TextComponent)Component.text((String)"[COPY TO FTP]").clickEvent(ClickEvent.runCommand((String)("/backuper menu " + this.storage + " \"" + backupName + "\" copyToFtpConfirmation")))).decorate(TextDecoration.BOLD)).color(TextColor.color((int)17, (int)102, (int)212))).append((Component)Component.space());
            }
            if (this.storage.equals("local") && Config.getInstance().getSftpConfig().isEnabled()) {
                message = message.append(((TextComponent)((TextComponent)Component.text((String)"[COPY TO SFTP]").clickEvent(ClickEvent.runCommand((String)("/backuper menu " + this.storage + " \"" + backupName + "\" copyToSftpConfirmation")))).decorate(TextDecoration.BOLD)).color(TextColor.color((int)17, (int)102, (int)212))).append((Component)Component.space());
            }
            if (this.storage.equals("sftp") && Config.getInstance().getLocalConfig().isEnabled() || this.storage.equals("ftp") && Config.getInstance().getFtpConfig().isEnabled() || this.storage.equals("googleDrive") && Config.getInstance().getGoogleDriveConfig().isEnabled()) {
                message = message.append(((TextComponent)((TextComponent)Component.text((String)"[COPY TO LOCAL]").clickEvent(ClickEvent.runCommand((String)("/backuper menu " + this.storage + " \"" + backupName + "\" copyToLocalConfirmation")))).decorate(TextDecoration.BOLD)).color(TextColor.color((int)17, (int)102, (int)212))).append((Component)Component.space());
            }
            message = message.append(((TextComponent)((TextComponent)Component.text((String)"[DELETE]").clickEvent(ClickEvent.runCommand((String)("/backuper menu " + this.storage + " \"" + backupName + "\" deleteConfirmation")))).decorate(TextDecoration.BOLD)).color(TextColor.color((int)11542784)));
            this.sendFramedMessage((Component)header, (Component)message, 15);
        } else {
            message = message.append((Component)Component.text((String)backupFormattedName)).append((Component)Component.space()).append((Component)Component.text((String)("(" + this.storage + ")"))).append((Component)Component.space()).append((Component)Component.text((String)zipOrFolder)).append((Component)Component.space()).append((Component)Component.text((long)backupMbSize)).append((Component)Component.space()).append((Component)Component.text((String)" MB"));
            this.sendFramedMessage((Component)header, (Component)message);
        }
    }
}

