/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu.copyToFtp;

import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.FtpBackup;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.common.Scheduler;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.tasks.Task;
import ru.dvdishka.backuper.backend.tasks.ftp.FtpSendFileFolderTask;
import ru.dvdishka.backuper.backend.utils.FtpUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.Permissions;
import ru.dvdishka.backuper.handlers.commands.task.status.StatusCommand;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class CopyToFtpCommand
extends Command {
    public CopyToFtpCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public void execute() {
        if (!Config.getInstance().getLocalConfig().isEnabled()) {
            this.cancelSound();
            this.returnFailure("Local storage is disabled");
            return;
        }
        if (!Config.getInstance().getFtpConfig().isEnabled()) {
            this.cancelSound();
            this.returnFailure("FTP storage is disabled");
            return;
        }
        LocalBackup localBackup = LocalBackup.getInstance((String)this.arguments.get("backupName"));
        if (localBackup == null) {
            this.cancelSound();
            this.returnFailure("Wrong backup name");
            return;
        }
        if (Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("Blocked by another operation!");
            return;
        }
        for (FtpBackup ftpBackup : FtpBackup.getBackups()) {
            if (!ftpBackup.getName().equals(localBackup.getName())) continue;
            this.cancelSound();
            this.returnFailure("Ftp storage already contains this backup");
            return;
        }
        this.buttonSound();
        StatusCommand.sendTaskStartedMessage("CopyToFtp", this.sender);
        Scheduler.getScheduler().runAsync(Utils.plugin, () -> {
            String inProgressName = localBackup.getName() + " in progress";
            if (localBackup.getFileType().equals("(ZIP)")) {
                inProgressName = inProgressName + ".zip";
            }
            FtpSendFileFolderTask task = new FtpSendFileFolderTask(localBackup.getFile(), FtpUtils.resolve(Config.getInstance().getFtpConfig().getBackupsFolder(), inProgressName), false, true, true, List.of(Permissions.LOCAL_COPY_TO_FTP), this.sender);
            ((Task)task).run();
            if (!task.isCancelled()) {
                FtpUtils.renameFile(FtpUtils.resolve(Config.getInstance().getFtpConfig().getBackupsFolder(), inProgressName), FtpUtils.resolve(Config.getInstance().getFtpConfig().getBackupsFolder(), localBackup.getFileName()), this.sender);
            }
            this.sendMessage("CopyToFtp task completed");
        });
    }
}

