/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu.copyToLocal;

import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.ExternalBackup;
import ru.dvdishka.backuper.backend.backup.FtpBackup;
import ru.dvdishka.backuper.backend.backup.GoogleDriveBackup;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.backup.SftpBackup;
import ru.dvdishka.backuper.backend.common.Scheduler;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.backend.utils.Utils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.task.status.StatusCommand;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class CopyToLocalCommand
extends Command {
    private String storage;

    public CopyToLocalCommand(String storage, CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
        this.storage = storage;
    }

    @Override
    public void execute() {
        if (!Config.getInstance().getLocalConfig().isEnabled()) {
            this.cancelSound();
            this.returnFailure("Local storage is disabled!");
            return;
        }
        if (this.storage.equals("sftp") && !Config.getInstance().getSftpConfig().isEnabled() || this.storage.equals("ftp") && !Config.getInstance().getFtpConfig().isEnabled() || this.storage.equals("googleDrive") && (!Config.getInstance().getGoogleDriveConfig().isEnabled() || !GoogleDriveUtils.isAuthorized(this.sender))) {
            this.cancelSound();
            if (!this.storage.equals("googleDrive")) {
                this.returnFailure(this.storage + " storage is disabled!");
            } else {
                this.returnFailure(this.storage + " storage is disabled or Google account is not linked!");
            }
            return;
        }
        ExternalBackup backup = null;
        if (this.storage.equals("sftp")) {
            backup = SftpBackup.getInstance((String)this.arguments.get("backupName"));
        }
        if (this.storage.equals("ftp")) {
            backup = FtpBackup.getInstance((String)this.arguments.get("backupName"));
        }
        if (this.storage.equals("googleDrive")) {
            backup = GoogleDriveBackup.getInstance((String)this.arguments.get("backupName"));
        }
        if (backup == null) {
            this.cancelSound();
            this.returnFailure("Wrong backup name");
            return;
        }
        if (Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("Blocked by another operation!");
            return;
        }
        for (LocalBackup localBackup : LocalBackup.getBackups()) {
            if (!localBackup.getName().equals(backup.getName())) continue;
            this.cancelSound();
            this.returnFailure("Local storage already contains this backup");
            return;
        }
        this.buttonSound();
        StatusCommand.sendTaskStartedMessage("CopyToLocal", this.sender);
        ExternalBackup.CopyToLocalTask copyToLocalTask = backup.getCopyToLocalTask(true, this.sender);
        Scheduler.getScheduler().runAsync(Utils.plugin, () -> {
            copyToLocalTask.run();
            this.sendMessage("CopyToLocal task completed");
        });
    }
}

