/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu.copyToSftp;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class CopyToSftpConfirmationCommand
extends Command {
    public CopyToSftpConfirmationCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public void execute() {
        String backupName = (String)this.arguments.get("backupName");
        if (!Config.getInstance().getSftpConfig().isEnabled()) {
            this.cancelSound();
            this.returnFailure("SFTP storage is disabled");
            return;
        }
        if (!LocalBackup.checkBackupExistenceByName(backupName)) {
            this.cancelSound();
            this.returnFailure("Backup does not exist!");
            return;
        }
        assert (backupName != null);
        LocalBackup backup = LocalBackup.getInstance(backupName);
        String backupFormattedName = backup.getFormattedName();
        if (Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("Blocked by another operation!");
            return;
        }
        this.buttonSound();
        long backupSize = backup.getMbSize(this.sender);
        String zipFolderBackup = backup.getFileType();
        TextComponent header = Component.empty();
        header = header.append(((TextComponent)Component.text((String)"Confirm copying to SFTP").decorate(TextDecoration.BOLD)).color(TextColor.color((int)11542784)));
        TextComponent message = Component.empty();
        message = message.append(Component.text((String)backupFormattedName).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("(local) " + zipFolderBackup + " " + backupSize + " MB"))))).append((Component)Component.newline()).append((Component)Component.newline());
        message = message.append(((TextComponent)((TextComponent)Component.text((String)"[COPY TO SFTP]").clickEvent(ClickEvent.runCommand((String)("/backuper menu local \"" + backupName + "\" copyToSftp")))).color(TextColor.color((int)11542784))).decorate(TextDecoration.BOLD));
        this.sendFramedMessage((Component)header, (Component)message, 15);
    }
}

