/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.menu.delete;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.ExternalBackup;
import ru.dvdishka.backuper.backend.backup.FtpBackup;
import ru.dvdishka.backuper.backend.backup.GoogleDriveBackup;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.backup.SftpBackup;
import ru.dvdishka.backuper.backend.config.Config;
import ru.dvdishka.backuper.backend.utils.GoogleDriveUtils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class DeleteConfirmationCommand
extends Command {
    private String storage = "";

    public DeleteConfirmationCommand(String storage, CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
        this.storage = storage;
    }

    @Override
    public void execute() {
        String backupName = (String)this.arguments.get("backupName");
        if (this.storage.equals("local") && !Config.getInstance().getLocalConfig().isEnabled() || this.storage.equals("sftp") && !Config.getInstance().getSftpConfig().isEnabled() || this.storage.equals("ftp") && !Config.getInstance().getFtpConfig().isEnabled() || this.storage.equals("googleDrive") && (!Config.getInstance().getGoogleDriveConfig().isEnabled() || !GoogleDriveUtils.isAuthorized(this.sender))) {
            this.cancelSound();
            if (!this.storage.equals("googleDrive")) {
                this.returnFailure(this.storage + " storage is disabled!");
            } else {
                this.returnFailure(this.storage + " storage is disabled or Google account is not linked!");
            }
            return;
        }
        if (this.storage.equals("local") && !LocalBackup.checkBackupExistenceByName(backupName) || this.storage.equals("sftp") && !SftpBackup.checkBackupExistenceByName(backupName) || this.storage.equals("ftp") && !FtpBackup.checkBackupExistenceByName(backupName) || this.storage.equals("googleDrive") && !GoogleDriveBackup.checkBackupExistenceByName(backupName)) {
            this.cancelSound();
            this.returnFailure("Backup does not exist!");
            return;
        }
        assert (backupName != null);
        ExternalBackup backup = null;
        if (this.storage.equals("local")) {
            backup = LocalBackup.getInstance(backupName);
        }
        if (this.storage.equals("sftp")) {
            backup = SftpBackup.getInstance(backupName);
        }
        if (this.storage.equals("ftp")) {
            backup = FtpBackup.getInstance(backupName);
        }
        if (this.storage.equals("googleDrive")) {
            backup = GoogleDriveBackup.getInstance(backupName);
        }
        String backupFormattedName = backup.getFormattedName();
        if (Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("Blocked by another operation!");
            return;
        }
        this.buttonSound();
        long backupSize = backup.getByteSize(this.sender) / 1024L;
        String zipFolderBackup = backup.getFileType();
        TextComponent header = Component.empty();
        header = header.append(((TextComponent)Component.text((String)"Confirm Deletion").decorate(TextDecoration.BOLD)).color(TextColor.color((int)11542784)));
        TextComponent message = Component.empty();
        message = message.append(Component.text((String)backupFormattedName).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("(" + this.storage + ") " + zipFolderBackup + " " + backupSize + " MB"))))).append((Component)Component.newline()).append((Component)Component.newline());
        message = message.append(((TextComponent)((TextComponent)Component.text((String)"[DELETE BACKUP]").clickEvent(ClickEvent.runCommand((String)("/backuper menu " + this.storage + " \"" + backupName + "\" delete")))).color(TextColor.color((int)11542784))).decorate(TextDecoration.BOLD));
        this.sendFramedMessage((Component)header, (Component)message, 15);
    }
}

