/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.task.cancel;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.Permissions;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class CancelConfirmationCommand
extends Command {
    public CancelConfirmationCommand(CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
    }

    @Override
    public void execute() {
        if (!Backuper.isLocked()) {
            this.cancelSound();
            this.returnFailure("There is no running task!");
            return;
        }
        if (!CancelConfirmationCommand.checkPermission(this.sender)) {
            this.cancelSound();
            this.returnFailure("You do not have permission to cancel this task!");
            return;
        }
        this.buttonSound();
        TextComponent header = Component.empty();
        header = header.append(((TextComponent)Component.text((String)"Confirm Task Cancelling").decorate(TextDecoration.BOLD)).color(TextColor.color((int)11542784)));
        TextComponent message = Component.empty();
        long progress = Backuper.getCurrentTask().getTaskPercentProgress();
        TextColor color = progress < 40L ? TextColor.color((int)190, (int)0, (int)27) : (progress < 75L ? TextColor.color((int)190, (int)151, (int)0) : TextColor.color((int)0, (int)156, (int)61));
        message = message.append((Component)Component.text((String)"Current task:")).append((Component)Component.space()).append(((TextComponent)Component.text((String)Backuper.getCurrentTask().getTaskName()).decorate(TextDecoration.BOLD)).color(TextColor.fromHexString((String)"#129c9b"))).append((Component)Component.newline()).append((Component)Component.text((String)"Task progress:")).append((Component)Component.space()).append(((TextComponent)Component.text((String)(progress + "%")).decorate(TextDecoration.BOLD)).color(color)).append((Component)Component.newline()).append((Component)Component.newline()).append(((TextComponent)((TextComponent)Component.text((String)"[CANCEL]").clickEvent(ClickEvent.runCommand((String)"/backuper task cancel"))).color(TextColor.color((int)11542784))).decorate(TextDecoration.BOLD));
        this.sendFramedMessage((Component)header, (Component)message, 15);
    }

    public static boolean checkPermission(CommandSender sender) {
        for (Permissions permission : Backuper.getCurrentTask().getPermissions()) {
            if (sender.hasPermission(permission.getPermission())) continue;
            return false;
        }
        return true;
    }
}

