/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.shade.commandapi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import ru.dvdishka.shade.commandapi.CommandAPIHandler;
import ru.dvdishka.shade.commandapi.CommandRegistrationStrategy;
import ru.dvdishka.shade.commandapi.RegisteredCommand;

public class PaperCommandRegistration<Source>
extends CommandRegistrationStrategy<Source> {
    private final Supplier<CommandDispatcher<Source>> getBrigadierDispatcher;
    private final Predicate<CommandNode<Source>> isBukkitCommand;
    private final RootCommandNode<Source> registeredNodes = new RootCommandNode();

    public PaperCommandRegistration(Supplier<CommandDispatcher<Source>> getBrigadierDispatcher, Predicate<CommandNode<Source>> isBukkitCommand) {
        this.getBrigadierDispatcher = getBrigadierDispatcher;
        this.isBukkitCommand = isBukkitCommand;
    }

    public boolean isBukkitCommand(CommandNode<Source> node) {
        return this.isBukkitCommand.test(node);
    }

    @Override
    public CommandDispatcher<Source> getBrigadierDispatcher() {
        return this.getBrigadierDispatcher.get();
    }

    @Override
    public void runTasksAfterServerStart() {
    }

    @Override
    public void postCommandRegistration(RegisteredCommand registeredCommand, LiteralCommandNode<Source> resultantNode, List<LiteralCommandNode<Source>> aliasNodes) {
    }

    @Override
    public LiteralCommandNode<Source> registerCommandNode(LiteralArgumentBuilder<Source> node, String namespace) {
        LiteralCommandNode commandNode = this.getBrigadierDispatcher.get().register(node);
        LiteralCommandNode namespacedCommandNode = CommandAPIHandler.getInstance().namespaceNode(commandNode, namespace);
        this.registeredNodes.addChild((CommandNode)commandNode);
        this.registeredNodes.addChild(namespacedCommandNode);
        this.getBrigadierDispatcher.get().getRoot().addChild(namespacedCommandNode);
        return commandNode;
    }

    @Override
    public void unregister(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
        this.removeBrigadierCommands(this.getBrigadierDispatcher.get().getRoot(), commandName, unregisterNamespaces, c -> !unregisterBukkit ^ this.isBukkitCommand.test((CommandNode<Source>)c));
        if (!unregisterBukkit) {
            this.removeBrigadierCommands(this.registeredNodes, commandName, unregisterNamespaces, c -> true);
        }
        CommandAPIHandler.getInstance().writeDispatcherToFile();
    }

    @Override
    public void preReloadDataPacks() {
        RootCommandNode root = this.getBrigadierDispatcher.get().getRoot();
        for (CommandNode commandNode : this.registeredNodes.getChildren()) {
            root.addChild(commandNode);
        }
    }
}

