/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.shade.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.dvdishka.shade.commandapi.CommandAPIBukkit;
import ru.dvdishka.shade.commandapi.CommandAPIHandler;
import ru.dvdishka.shade.commandapi.arguments.Argument;
import ru.dvdishka.shade.commandapi.arguments.CommandAPIArgumentType;
import ru.dvdishka.shade.commandapi.arguments.GreedyArgument;
import ru.dvdishka.shade.commandapi.arguments.PreviewInfo;
import ru.dvdishka.shade.commandapi.arguments.Previewable;
import ru.dvdishka.shade.commandapi.commandsenders.BukkitPlayer;
import ru.dvdishka.shade.commandapi.exceptions.PaperAdventureNotFoundException;
import ru.dvdishka.shade.commandapi.exceptions.WrapperCommandSyntaxException;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;
import ru.dvdishka.shade.commandapi.wrappers.PreviewableFunction;

public class AdventureChatArgument
extends Argument<Component>
implements GreedyArgument,
Previewable<AdventureChatArgument, Component> {
    private PreviewableFunction<Component> preview;
    private boolean usePreview;

    public AdventureChatArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get()._ArgumentChat());
        try {
            Class.forName("net.kyori.adventure.text.Component");
        }
        catch (ClassNotFoundException e) {
            throw new PaperAdventureNotFoundException(this.getClass());
        }
    }

    @Override
    public Class<Component> getPrimitiveType() {
        return Component.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.ADVENTURE_CHAT;
    }

    @Override
    public <CommandSourceStack> Component parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        CommandSender sender = (CommandSender)CommandAPIBukkit.get().getCommandSenderFromCommandSource(cmdCtx.getSource()).getSource();
        Component component = CommandAPIBukkit.get().getAdventureChat(cmdCtx, key);
        Optional<PreviewableFunction<Component>> previewOptional = this.getPreview();
        if (this.usePreview && previewOptional.isPresent() && sender instanceof Player) {
            Player player = (Player)sender;
            try {
                Component previewComponent;
                component = previewComponent = previewOptional.get().generatePreview(new PreviewInfo<Component>(new BukkitPlayer(player), CommandAPIHandler.getRawArgumentInput(cmdCtx, key), cmdCtx.getInput(), component));
            }
            catch (WrapperCommandSyntaxException e) {
                throw e.getException();
            }
        }
        return component;
    }

    @Override
    public AdventureChatArgument withPreview(PreviewableFunction<Component> preview) {
        this.preview = preview;
        return this;
    }

    @Override
    public Optional<PreviewableFunction<Component>> getPreview() {
        return Optional.ofNullable(this.preview);
    }

    @Override
    public boolean isLegacy() {
        return false;
    }

    @Override
    public AdventureChatArgument usePreview(boolean usePreview) {
        this.usePreview = usePreview;
        return this;
    }
}

