/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend;

import java.util.Arrays;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.task.TaskException;
import ru.dvdishka.backuper.backend.util.UIUtils;

public class LogManager {
    public void log(String text) {
        Backuper.getInstance().getLogger().info(text);
    }

    public void log(String text, CommandSender sender) {
        Backuper.getInstance().getLogger().info(text);
        if (!(sender instanceof ConsoleCommandSender)) {
            try {
                UIUtils.sendMessage(text, sender);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void log(Component text, CommandSender sender) {
        Component consoleText = text;
        if (!(sender instanceof ConsoleCommandSender)) {
            consoleText = Component.newline().append(text);
        }
        Backuper.getInstance().getComponentLogger().info(consoleText);
        if (!(sender instanceof ConsoleCommandSender)) {
            try {
                text = Component.newline().append(text);
                UIUtils.sendMessage(text, sender);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void devLog(String text) {
        if (Backuper.getInstance().getConfigManager().getServerConfig().isBetterLogging()) {
            Backuper.getInstance().getLogger().info(text);
        }
    }

    public void devLog(String text, CommandSender sender) {
        if (Backuper.getInstance().getConfigManager().getServerConfig().isBetterLogging()) {
            Backuper.getInstance().getLogger().info(text);
            if (!(sender instanceof ConsoleCommandSender)) {
                try {
                    UIUtils.sendMessage(text, sender);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void warn(String text) {
        Backuper.getInstance().getLogger().warning(text);
    }

    public void warn(TaskException taskException) {
        Backuper.getInstance().getLogger().warning(taskException.getMessage());
        Backuper.getInstance().getLogger().warning(taskException.getException().getMessage());
        Backuper.getInstance().getLogger().warning(Arrays.toString(taskException.getException().getStackTrace()));
    }

    public void warn(String text, CommandSender sender) {
        Backuper.getInstance().getLogger().warning(text);
        if (!(sender instanceof ConsoleCommandSender)) {
            try {
                UIUtils.returnWarning(text, sender);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void success(String text) {
        Backuper.getInstance().getLogger().info(text);
    }

    public void success(String text, CommandSender sender) {
        Backuper.getInstance().getLogger().info(text);
        if (!(sender instanceof ConsoleCommandSender)) {
            try {
                UIUtils.returnSuccess(text, sender);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void devWarn(String text) {
        if (!Backuper.getInstance().isEnabled()) {
            return;
        }
        if (Backuper.getInstance().getConfigManager().getServerConfig().isBetterLogging()) {
            Backuper.getInstance().getLogger().warning(text);
        }
    }

    public void warn(Exception exception) {
        if (!Backuper.getInstance().isEnabled()) {
            return;
        }
        Backuper.getInstance().getLogger().warning("%s\n%s".formatted(exception.getMessage(), Arrays.toString(exception.getStackTrace())));
    }

    public void devWarn(Exception exception) {
        if (!Backuper.getInstance().isEnabled()) {
            return;
        }
        if (Backuper.getInstance().getConfigManager().getServerConfig().isBetterLogging()) {
            Backuper.getInstance().getLogger().warning("%s\n%s".formatted(exception.getMessage(), Arrays.toString(exception.getStackTrace())));
        }
    }
}

