/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.autobackup;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.task.BackupTask;
import ru.dvdishka.backuper.backend.task.TaskManager;
import ru.dvdishka.backuper.backend.util.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Permission;

public class AutoBackupJob {
    public void executeBackup() {
        if (!Backuper.getInstance().getConfigManager().getBackupConfig().isAutoBackup()) {
            return;
        }
        Backuper.getInstance().getScheduleManager().runAsync(() -> {
            List<Storage> autoBackupStorages = Backuper.getInstance().getStorageManager().getStorages().stream().filter(storage -> storage.getConfig().isAutoBackup()).toList();
            BackupTask backupTask = new BackupTask(autoBackupStorages, Backuper.getInstance().getConfigManager().getBackupConfig().getAfterBackup(), true);
            ArrayList<String> permissions = new ArrayList<String>(){};
            permissions.addAll(autoBackupStorages.stream().map(Permission.BACKUP::getPermission).toList());
            if ("RESTART".equals(Backuper.getInstance().getConfigManager().getBackupConfig().getAfterBackup())) {
                permissions.add(Permission.RESTART.getPermission());
            }
            if ("STOP".equals(Backuper.getInstance().getConfigManager().getBackupConfig().getAfterBackup())) {
                permissions.add(Permission.STOP.getPermission());
            }
            if (TaskManager.Result.LOCKED.equals((Object)Backuper.getInstance().getTaskManager().startTask(backupTask, (CommandSender)Bukkit.getConsoleSender(), (List<String>)permissions))) {
                Backuper.getInstance().getLogManager().warn("Failed to start an Auto Backup task. Blocked by another operation", (CommandSender)Bukkit.getConsoleSender());
            }
        });
    }

    public void executeAlert(long timeSeconds, String afterBackup) {
        if (Backuper.getInstance().getConfigManager().getServerConfig().getAlertTimeBeforeRestart() == -1L) {
            return;
        }
        boolean restart = false;
        if (afterBackup.equals("STOP")) {
            Backuper.getInstance().getLogManager().log(Backuper.getInstance().getConfigManager().getServerConfig().getAlertBackupRestartMessage().formatted(timeSeconds));
            restart = true;
        }
        if (afterBackup.equals("RESTART")) {
            Backuper.getInstance().getLogManager().log(Backuper.getInstance().getConfigManager().getServerConfig().getAlertBackupRestartMessage().formatted(timeSeconds));
            restart = true;
        }
        if (afterBackup.equals("NOTHING")) {
            Backuper.getInstance().getLogManager().log(Backuper.getInstance().getConfigManager().getServerConfig().getAlertBackupMessage().formatted(timeSeconds));
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission(Permission.ALERT.getPermission()) || !restart && Backuper.getInstance().getConfigManager().getServerConfig().isAlertOnlyServerRestart()) continue;
            TextComponent header = Component.empty();
            header = header.append(Component.text((String)"Backup Alert").decorate(TextDecoration.BOLD));
            TextComponent message = Component.empty();
            message = message.append((Component)Component.text((String)(restart ? Backuper.getInstance().getConfigManager().getServerConfig().getAlertBackupRestartMessage() : Backuper.getInstance().getConfigManager().getServerConfig().getAlertBackupMessage()).formatted(timeSeconds)));
            UIUtils.sendFramedMessage((Component)header, (Component)message, 15, (CommandSender)player);
            UIUtils.notificationSound((CommandSender)player);
        }
    }
}

