/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.backup;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.backup.FtpBackup;
import ru.dvdishka.backuper.backend.backup.GoogleDriveBackup;
import ru.dvdishka.backuper.backend.backup.LocalBackup;
import ru.dvdishka.backuper.backend.backup.SftpBackup;
import ru.dvdishka.backuper.backend.storage.FtpStorage;
import ru.dvdishka.backuper.backend.storage.GoogleDriveStorage;
import ru.dvdishka.backuper.backend.storage.LocalStorage;
import ru.dvdishka.backuper.backend.storage.SftpStorage;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.storage.StorageType;
import ru.dvdishka.backuper.backend.storage.exception.StorageConnectionException;
import ru.dvdishka.backuper.backend.storage.exception.StorageMethodException;

public class BackupManager {
    private final Storage storage;
    private final HashMap<String, Backup> backups = new HashMap();
    final Cache<String, Long> cachedBackupsSize = Caffeine.newBuilder().build();
    private final Cache<String, List<Backup>> cacheGetBackupList = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).expireAfterAccess(5L, TimeUnit.SECONDS).build();

    public BackupManager(Storage storage) {
        this.storage = storage;
    }

    public Backup getBackup(String backupName) {
        if (!this.checkBackupExists(backupName)) {
            return null;
        }
        Storage storage = this.storage;
        Objects.requireNonNull(storage);
        Storage storage2 = storage;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalStorage.class, FtpStorage.class, SftpStorage.class, GoogleDriveStorage.class}, (Object)storage2, n)) {
            case 0 -> {
                LocalStorage localStorage = (LocalStorage)storage2;
                yield this.backups.computeIfAbsent(backupName, name -> new LocalBackup(localStorage, (String)name));
            }
            case 1 -> {
                FtpStorage ftpStorage = (FtpStorage)storage2;
                yield this.backups.computeIfAbsent(backupName, name -> new FtpBackup(ftpStorage, (String)name));
            }
            case 2 -> {
                SftpStorage sftpStorage = (SftpStorage)storage2;
                yield this.backups.computeIfAbsent(backupName, name -> new SftpBackup(sftpStorage, (String)name));
            }
            case 3 -> {
                GoogleDriveStorage googleDriveStorage = (GoogleDriveStorage)storage2;
                yield this.backups.computeIfAbsent(backupName, name -> new GoogleDriveBackup(googleDriveStorage, (String)name));
            }
            default -> null;
        };
    }

    public List<Backup> getBackupList() throws StorageConnectionException, StorageMethodException {
        return this.cacheGetBackupList.get("all", key -> {
            ArrayList<Backup> backups = new ArrayList<Backup>();
            for (String fileName : this.storage.ls(this.storage.getConfig().getBackupsFolder())) {
                Backup backup = this.getBackup(fileName.replace(".zip", ""));
                if (backup == null) continue;
                backups.add(backup);
            }
            return backups;
        });
    }

    public boolean checkBackupExists(String backupName) {
        try {
            LocalDateTime.parse(backupName, Backuper.getInstance().getConfigManager().getBackupConfig().getDateTimeFormatter());
            return this.storage.ls(this.storage.getConfig().getBackupsFolder()).stream().anyMatch(file -> file.equals(backupName) || file.equals("%s.zip".formatted(backupName)));
        }
        catch (Exception e) {
            return false;
        }
    }

    public void saveBackupSizeToCache(String backupName, long byteSize) {
        this.cachedBackupsSize.put(backupName, byteSize);
        if (StorageType.GOOGLE_DRIVE.equals((Object)this.storage.getType())) {
            GoogleDriveBackup backup = (GoogleDriveBackup)this.getBackup(backupName);
            if (backup == null) {
                throw new RuntimeException("Tried to save nonexistent backup's size to cache");
            }
            backup.saveSizeToFileProperties(byteSize);
        }
    }

    public void invalidateBackupSizeCache(String backupName) {
        this.cachedBackupsSize.invalidate(backupName);
    }

    public ConcurrentMap<String, Long> getSizeCache() {
        return this.cachedBackupsSize.asMap();
    }

    public void loadSizeCache(Map<String, Long> cache) {
        this.cachedBackupsSize.invalidateAll();
        this.cachedBackupsSize.putAll(cache);
    }
}

