/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.backup;

import com.google.api.services.drive.model.File;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.storage.GoogleDriveStorage;

public class GoogleDriveBackup
implements Backup {
    private final String backupName;
    private final GoogleDriveStorage storage;

    GoogleDriveBackup(GoogleDriveStorage storage, String backupName) {
        this.backupName = backupName;
        this.storage = storage;
    }

    @Override
    public GoogleDriveStorage getStorage() {
        return this.storage;
    }

    @Override
    public String getName() {
        return this.backupName;
    }

    @Override
    public long calculateByteSize() {
        try {
            String stringSize = this.getDriveFile().getAppProperties().get("size");
            return Long.parseLong(stringSize);
        }
        catch (Exception e) {
            return Backup.super.calculateByteSize();
        }
    }

    public boolean saveSizeToFileProperties(long byteSize) {
        try {
            this.storage.addProperty(this.getDriveFile().getId(), "size", String.valueOf(byteSize));
            return true;
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().warn("Failed to save backup size to Google Drive");
            Backuper.getInstance().getLogManager().warn(e);
            return false;
        }
    }

    public File getDriveFile() {
        try {
            return this.storage.getFileByName(this.backupName + (Backup.BackupFileType.ZIP.equals((Object)this.getFileType()) ? ".zip" : ""), this.storage.getConfig().getBackupsFolderId());
        }
        catch (Exception e) {
            return null;
        }
    }
}

