/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.backup;

import java.io.File;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.storage.LocalStorage;

public class LocalBackup
implements Backup {
    private final String backupName;
    private final LocalStorage storage;

    LocalBackup(LocalStorage storage, String backupName) {
        this.backupName = backupName;
        this.storage = storage;
    }

    @Override
    public String getName() {
        return this.backupName;
    }

    public File getFile() {
        File backupsFolder = new File(this.storage.getConfig().getBackupsFolder());
        if (Backup.BackupFileType.ZIP.equals((Object)this.getFileType())) {
            return backupsFolder.toPath().resolve("%s.zip".formatted(this.backupName)).toFile();
        }
        return backupsFolder.toPath().resolve(this.backupName).toFile();
    }

    @Override
    public LocalStorage getStorage() {
        return this.storage;
    }
}

