/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.config;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.config.BackupConfig;
import ru.dvdishka.backuper.backend.config.ConfigBackwardsCompatibility;
import ru.dvdishka.backuper.backend.config.FtpConfig;
import ru.dvdishka.backuper.backend.config.GoogleDriveConfig;
import ru.dvdishka.backuper.backend.config.LocalConfig;
import ru.dvdishka.backuper.backend.config.ServerConfig;
import ru.dvdishka.backuper.backend.config.SftpConfig;
import ru.dvdishka.backuper.backend.storage.FtpStorage;
import ru.dvdishka.backuper.backend.storage.GoogleDriveStorage;
import ru.dvdishka.backuper.backend.storage.LocalStorage;
import ru.dvdishka.backuper.backend.storage.SftpStorage;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.shade.commandapi.CommandAPI;

public class ConfigManager {
    private File configFile;
    private long lastBackup;
    private long lastChange;
    private BackupConfig backupConfig;
    private ServerConfig serverConfig;

    public synchronized void setConfigField(String path, Object value) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        config.set(path, value);
        try {
            config.save(this.configFile);
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().warn("Failed to save config.yml file");
        }
    }

    public void updateLastChange() {
        this.lastChange = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
    }

    public void updateLastBackup() {
        this.lastBackup = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
    }

    public void load(File configFile, CommandSender sender) {
        if (!configFile.exists()) {
            Backuper.getInstance().saveDefaultConfig();
        }
        Backuper.getInstance().getLogManager().log("loading config...", sender);
        this.configFile = configFile;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        ConfigBackwardsCompatibility.configBelow4((FileConfiguration)config);
        ConfigBackwardsCompatibility.configBelow8((FileConfiguration)config);
        ConfigBackwardsCompatibility.configBelow13((FileConfiguration)config);
        this.loadBackupConfig((ConfigurationSection)config);
        this.loadStorages((ConfigurationSection)config);
        this.loadServerConfig((ConfigurationSection)config);
        this.lastBackup = config.getLong("lastBackup", 0L);
        this.lastChange = config.getLong("lastChange", 0L);
        config.set("configVersion", (Object)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Backuper.getInstance().getResource("config.yml"))).getDouble("configVersion"));
        try {
            config.save(configFile);
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().warn("Failed to save repaired config.yml file", sender);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            CommandAPI.updateRequirements(player);
        }
        Backuper.getInstance().getLogManager().log("Config has been loaded", sender);
    }

    private void loadBackupConfig(ConfigurationSection config) {
        ConfigurationSection backupSection = config.getConfigurationSection("backup");
        this.backupConfig = (BackupConfig)new BackupConfig().repairThenLoad(backupSection);
        config.set("backup", (Object)this.backupConfig.getConfig());
    }

    private void loadStorages(ConfigurationSection config) {
        ConfigurationSection storagesSection = config.getConfigurationSection("storages");
        storagesSection.getKeys(false).forEach(key -> {
            Storage storage;
            String storageType;
            String storageId = key;
            ConfigurationSection storageSection = storagesSection.getConfigurationSection(storageId);
            switch (storageType = storageSection.getString("type", "")) {
                case "local": {
                    Storage storage2 = new LocalStorage((LocalConfig)new LocalConfig().repairThenLoad(storageSection));
                    break;
                }
                case "ftp": {
                    Storage storage2 = new FtpStorage((FtpConfig)new FtpConfig().repairThenLoad(storageSection));
                    break;
                }
                case "sftp": {
                    Storage storage2 = new SftpStorage((SftpConfig)new SftpConfig().repairThenLoad(storageSection));
                    break;
                }
                case "googleDrive": {
                    Storage storage2 = new GoogleDriveStorage((GoogleDriveConfig)new GoogleDriveConfig().repairThenLoad(storageSection));
                    break;
                }
                default: {
                    Backuper.getInstance().getLogManager().warn("Wrong storage type \"%s\" in \"%s\" storage in config.yml. Skipping this storage...".formatted(storageType, storageId));
                    Storage storage2 = storage = null;
                }
            }
            if (storage != null) {
                storagesSection.set(storageId, (Object)storage.getConfig().getConfig());
            }
            if (storage != null && storage.getConfig().isEnabled()) {
                Backuper.getInstance().getStorageManager().registerStorage(storageId, storage);
            }
        });
        config.set("storages", (Object)storagesSection);
    }

    private void loadServerConfig(ConfigurationSection config) {
        ConfigurationSection serverSection = config.getConfigurationSection("server");
        this.serverConfig = (ServerConfig)new ServerConfig().repairThenLoad(serverSection);
        config.set("server", (Object)this.serverConfig.getConfig());
    }

    @Generated
    public long getLastBackup() {
        return this.lastBackup;
    }

    @Generated
    public long getLastChange() {
        return this.lastChange;
    }

    @Generated
    public BackupConfig getBackupConfig() {
        return this.backupConfig;
    }

    @Generated
    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }
}

