/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.config;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.config.StorageConfig;
import ru.dvdishka.backuper.backend.storage.GoogleDriveStorage;

public class GoogleDriveConfig
implements StorageConfig {
    private String id;
    private boolean enabled;
    private boolean autoBackup;
    private File tokenFolder;
    private String backupsFolderId;
    private boolean createBackuperFolder;
    private int backupsNumber;
    private long backupsWeight;
    private boolean zipArchive;
    private int zipCompressionLevel;
    private ConfigurationSection config;

    @Override
    public GoogleDriveConfig load(ConfigurationSection config, String name) {
        this.config = config;
        this.id = name;
        this.enabled = config.getBoolean("enabled");
        this.autoBackup = config.getBoolean("autoBackup");
        this.backupsFolderId = config.getString("backupsFolderId");
        String googleDriveTokenFolder = config.getString("auth.tokenFolderPath");
        this.tokenFolder = new File(googleDriveTokenFolder);
        this.createBackuperFolder = config.getBoolean("createBackuperFolder");
        this.backupsNumber = config.getInt("maxBackupsNumber");
        this.backupsWeight = config.getLong("maxBackupsWeight") * 0x100000L;
        this.zipArchive = config.getBoolean("zipArchive");
        int zipCompressionLevel = config.getInt("zipCompressionLevel");
        if (zipCompressionLevel > 9 || zipCompressionLevel < 0) {
            Backuper.getInstance().getLogManager().warn("Failed to load config value!");
            if (zipCompressionLevel < 0) {
                Backuper.getInstance().getLogManager().warn("zipCompressionLevel must be >= 0, using 0 value...");
                zipCompressionLevel = 0;
            }
            if (zipCompressionLevel > 9) {
                Backuper.getInstance().getLogManager().warn("zipCompressionLevel must be <= 9, using 9 value...");
                zipCompressionLevel = 9;
            }
        }
        this.zipCompressionLevel = zipCompressionLevel;
        return this;
    }

    public String getRawBackupFolderId() {
        return this.backupsFolderId;
    }

    public String getBackupsFolderId() {
        if (!this.createBackuperFolder) {
            return this.backupsFolderId;
        }
        GoogleDriveStorage storage = (GoogleDriveStorage)Backuper.getInstance().getStorageManager().getStorage(this.id);
        if (storage == null) {
            throw new RuntimeException("Tried to get backupsFolder from unregistered \"%s\" GoogleDrive storage".formatted(this.id));
        }
        for (com.google.api.services.drive.model.File driveFile : storage.ls(this.backupsFolderId, "appProperties has { key='root' and value='true' }")) {
            if (!driveFile.getName().equals("Backuper")) continue;
            return driveFile.getId();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", "true");
        storage.createDir("Backuper", this.backupsFolderId, properties);
        return storage.getFileByName("Backuper", this.backupsFolderId).getId();
    }

    @Override
    public String getBackupsFolder() {
        return this.getBackupsFolderId();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ConfigurationSection getDefaultConfig() {
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Backuper.getInstance().getResource("google_drive_config.yml")));
    }

    @Override
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Generated
    public boolean isAutoBackup() {
        return this.autoBackup;
    }

    @Generated
    public File getTokenFolder() {
        return this.tokenFolder;
    }

    @Generated
    public boolean isCreateBackuperFolder() {
        return this.createBackuperFolder;
    }

    @Override
    @Generated
    public int getBackupsNumber() {
        return this.backupsNumber;
    }

    @Override
    @Generated
    public long getBackupsWeight() {
        return this.backupsWeight;
    }

    @Override
    @Generated
    public boolean isZipArchive() {
        return this.zipArchive;
    }

    @Override
    @Generated
    public int getZipCompressionLevel() {
        return this.zipCompressionLevel;
    }

    @Override
    @Generated
    public ConfigurationSection getConfig() {
        return this.config;
    }
}

