/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.storage;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.BackupManager;
import ru.dvdishka.backuper.backend.config.FtpConfig;
import ru.dvdishka.backuper.backend.storage.FtpClientProvider;
import ru.dvdishka.backuper.backend.storage.PathStorage;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.storage.StorageType;
import ru.dvdishka.backuper.backend.storage.exception.StorageConnectionException;
import ru.dvdishka.backuper.backend.storage.exception.StorageLimitException;
import ru.dvdishka.backuper.backend.storage.exception.StorageMethodException;
import ru.dvdishka.backuper.backend.storage.util.Retriable;
import ru.dvdishka.backuper.backend.storage.util.StorageProgressListener;

public class FtpStorage
implements PathStorage {
    private String id = null;
    private final FtpConfig config;
    private final BackupManager backupManager;
    private final FtpClientProvider mainClient;
    private final FtpClientProvider downloadClient;
    private final FtpClientProvider uploadClient;
    private final Retriable.RetriableExceptionHandler retriableExceptionHandler = new Retriable.RetriableExceptionHandler(){

        @Override
        public void handleRegularException(Exception e) {
            if (e instanceof SocketTimeoutException || e.getMessage() != null && e.getMessage().contains("Read timed out")) {
                Backuper.getInstance().getLogManager().devWarn("FTP read timeout");
            } else if (e instanceof SocketException && e.getMessage() != null && (e.getMessage().contains("Connection reset") || e.getMessage().contains("Connection closed") || e.getMessage().contains("Broken pipe"))) {
                Backuper.getInstance().getLogManager().devWarn("FTP connection reset");
            } else if (e instanceof IOException && e.getMessage() != null && e.getMessage().contains("Could not parse passive host information")) {
                Backuper.getInstance().getLogManager().devWarn("FTP passive mode error");
            }
        }

        @Override
        public RuntimeException handleFinalException(Exception e) {
            if (e instanceof IOException && e.getMessage() != null) {
                if (e.getMessage().contains("421") || e.getMessage().contains("Failed to establish connection")) {
                    return new StorageConnectionException(this.getStorage(), "Failed to establish connection to FTP server", e);
                }
                if (e.getMessage().contains("timed out") || e.getMessage().contains("Read timed out")) {
                    return new StorageConnectionException(this.getStorage(), "Connection timed out", e);
                }
                if (e.getMessage().contains("Could not parse passive host information")) {
                    return new StorageMethodException(this.getStorage(), "Failed to establish passive connection", e);
                }
                if (e.getMessage().contains("550") && (e.getMessage().contains("quota exceeded") || e.getMessage().contains("disk full"))) {
                    return new StorageLimitException(this.getStorage(), "FTP storage quota exceeded", e);
                }
                if (e.getMessage().contains("550") || e.getMessage().contains("Permission denied")) {
                    return new StorageMethodException(this.getStorage(), "Access denied or file not found", e);
                }
            }
            if (e.getMessage() != null && e.getMessage().contains("in is null")) {
                return new StorageMethodException(this.getStorage(), "Failed to get input stream", e);
            }
            return new StorageMethodException(this.getStorage(), e.getMessage(), e);
        }

        public Storage getStorage() {
            return FtpStorage.this;
        }
    };

    public FtpStorage(FtpConfig config) {
        this.config = config;
        this.backupManager = new BackupManager(this);
        this.mainClient = new FtpClientProvider(this);
        this.downloadClient = new FtpClientProvider(this);
        this.uploadClient = new FtpClientProvider(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public StorageType getType() {
        return StorageType.FTP;
    }

    @Override
    public FtpConfig getConfig() {
        return this.config;
    }

    @Override
    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    @Override
    public boolean checkConnection() {
        return this.checkConnection(null);
    }

    @Override
    public boolean checkConnection(CommandSender sender) {
        try {
            this.mainClient.getClient();
            this.downloadClient.getClient();
            this.uploadClient.getClient();
            return true;
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().warn("Failed to establish connection to the FTP(S) server", sender);
            Backuper.getInstance().getLogManager().warn(e);
            return false;
        }
    }

    @Override
    public List<String> ls(String path) throws StorageMethodException, StorageConnectionException {
        return ((Retriable<List>)() -> {
            FtpClientProvider ftpClientProvider = this.mainClient;
            synchronized (ftpClientProvider) {
                FTPClient ftp = this.mainClient.getClient();
                ftp.changeWorkingDirectory(path);
                FTPFile[] files = ftp.listFiles();
                if (files == null) {
                    throw new IOException("Failed to list files in directory: " + path);
                }
                return Arrays.stream(files).map(FTPFile::getName).filter(fileName -> !fileName.equals(".") && !fileName.equals("..")).toList();
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public String resolve(String path, String fileName) {
        if (path == null) {
            return fileName;
        }
        if (!path.endsWith(this.config.getPathSeparatorSymbol())) {
            path = "%s%s".formatted(path, this.config.getPathSeparatorSymbol());
        }
        return "%s%s".formatted(path, fileName);
    }

    @Override
    public boolean exists(String path) throws StorageMethodException, StorageConnectionException {
        return ((Retriable<Boolean>)() -> {
            FtpClientProvider ftpClientProvider = this.mainClient;
            synchronized (ftpClientProvider) {
                FTPClient ftp = this.mainClient.getClient();
                String parentPath = this.getParentPath(path);
                String fileName = this.getFileNameFromPath(path);
                if (!ftp.changeWorkingDirectory(parentPath)) {
                    return false;
                }
                return Arrays.stream(ftp.listFiles()).map(FTPFile::getName).anyMatch(name -> name.equals(fileName));
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public boolean isFile(String path) throws StorageMethodException, StorageConnectionException {
        return ((Retriable<Boolean>)() -> {
            FtpClientProvider ftpClientProvider = this.mainClient;
            synchronized (ftpClientProvider) {
                FTPClient ftp = this.mainClient.getClient();
                String parentPath = this.getParentPath(path);
                String fileName = this.getFileNameFromPath(path);
                if (!ftp.changeWorkingDirectory(path)) {
                    if (!ftp.changeWorkingDirectory(parentPath)) {
                        return false;
                    }
                    return Arrays.stream(ftp.listFiles()).map(FTPFile::getName).anyMatch(name -> name.equals(fileName));
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                FTPFile[] listFiles = ftp.listFiles();
                return listFiles.length == 0 || listFiles.length == 1 && listFiles[0].getName().equals(this.getFileNameFromPath(path));
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public long getDirByteSize(String path) throws StorageMethodException, StorageConnectionException {
        return ((Retriable<Long>)() -> {
            FTPFile[] files = new FTPFile[]{};
            long dirSize = 0L;
            FTPFile[] fTPFileArray = this.mainClient;
            synchronized (this.mainClient) {
                FTPClient ftp = this.mainClient.getClient();
                String parentPath = this.getParentPath(path);
                String fileName = this.getFileNameFromPath(path);
                ftp.changeWorkingDirectory(parentPath);
                if (this.isFile(path)) {
                    dirSize += Long.valueOf(ftp.getSize(fileName)).longValue();
                }
                if (this.isDir(path) && (files = ftp.listFiles()) == null) {
                    throw new StorageMethodException(this, "Failed to list files in directory: " + path);
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                for (FTPFile file : files) {
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    dirSize += this.getDirByteSize(this.resolve(path, file.getName()));
                }
                return dirSize;
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public void createDir(String newDirName, String parentDir) throws StorageMethodException, StorageConnectionException {
        ((Retriable<Void>)() -> {
            FtpClientProvider ftpClientProvider = this.mainClient;
            synchronized (ftpClientProvider) {
                FTPClient ftp = this.mainClient.getClient();
                ftp.changeWorkingDirectory(parentDir);
                ftp.mkd(newDirName);
                return null;
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public void uploadFile(InputStream sourceStream, String newFileName, String targetParentDir, StorageProgressListener progressListener) throws StorageLimitException, StorageMethodException, StorageConnectionException {
        ((Retriable<Void>)() -> {
            FtpClientProvider ftpClientProvider = this.uploadClient;
            synchronized (ftpClientProvider) {
                FTPClient ftp = this.uploadClient.getClient();
                ftp.setCopyStreamListener(new FtpStorageProgressListener(progressListener));
                ftp.changeWorkingDirectory(targetParentDir);
                if (!ftp.storeFile(newFileName, sourceStream)) {
                    throw new StorageMethodException(this, "Failed to upload stream to \"%s\"".formatted(this.resolve(ftp.printWorkingDirectory(), newFileName)), new RuntimeException(ftp.getReplyString()));
                }
                return null;
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public InputStream downloadFile(String sourcePath, StorageProgressListener progressListener) throws StorageMethodException, StorageConnectionException {
        return ((Retriable<InputStream>)() -> {
            FtpClientProvider ftpClientProvider = this.downloadClient;
            synchronized (ftpClientProvider) {
                FTPClient ftp = this.downloadClient.getClient();
                String parentPath = this.getParentPath(sourcePath);
                String fileName = this.getFileNameFromPath(sourcePath);
                ftp.changeWorkingDirectory(parentPath);
                return new FtpStorageInputStream(ftp.retrieveFileStream(fileName), progressListener);
            }
        }).retry(this.retriableExceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadCompleted() throws StorageMethodException, StorageConnectionException {
        try {
            FtpClientProvider ftpClientProvider = this.downloadClient;
            synchronized (ftpClientProvider) {
                FTPClient ftp = this.downloadClient.getClient();
                boolean completed = ftp.completePendingCommand();
                if (!completed) {
                    Backuper.getInstance().getLogManager().devWarn("FTP command completion returned false");
                }
            }
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().devWarn(e);
        }
    }

    @Override
    public void delete(String path) throws StorageMethodException, StorageConnectionException {
        ((Retriable<Void>)() -> {
            FtpClientProvider ftpClientProvider = this.mainClient;
            synchronized (ftpClientProvider) {
                FTPClient ftp = this.mainClient.getClient();
                String parentPath = this.getParentPath(path);
                String fileName = this.getFileNameFromPath(path);
                ftp.changeWorkingDirectory(parentPath);
                if (this.isFile(path)) {
                    this.mainClient.resetWorkingDirectory();
                    ftp.changeWorkingDirectory(parentPath);
                    ftp.deleteFile(fileName);
                } else {
                    this.mainClient.resetWorkingDirectory();
                    ftp.changeWorkingDirectory(parentPath);
                    ftp.removeDirectory(fileName);
                }
                return null;
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public void renameFile(String path, String newFileName) throws StorageMethodException, StorageConnectionException {
        ((Retriable<Void>)() -> {
            FtpClientProvider ftpClientProvider = this.mainClient;
            synchronized (ftpClientProvider) {
                FTPClient ftp = this.mainClient.getClient();
                String parentPath = this.getParentPath(path);
                String fileName = this.getFileNameFromPath(path);
                ftp.changeWorkingDirectory(parentPath);
                ftp.rename(fileName, newFileName);
                return null;
            }
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public int getStorageSpeedMultiplier() {
        return 8;
    }

    @Override
    public void destroy() {
        this.mainClient.disconnect();
        this.downloadClient.disconnect();
        this.uploadClient.disconnect();
    }

    @Override
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    private static class FtpStorageInputStream
    extends InputStream {
        private final InputStream inputStream;
        private final StorageProgressListener progressListener;

        FtpStorageInputStream(InputStream inputStream, StorageProgressListener progressListener) {
            this.inputStream = inputStream;
            this.progressListener = progressListener;
        }

        @Override
        public int read() throws IOException {
            int result = this.inputStream.read();
            if (result != -1) {
                this.progressListener.incrementProgress(1L);
            }
            return result;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int bytesRead = this.inputStream.read(b);
            if (bytesRead > 0) {
                this.progressListener.incrementProgress(bytesRead);
            }
            return bytesRead;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int bytesRead = this.inputStream.read(b, off, len);
            if (bytesRead > 0) {
                this.progressListener.incrementProgress(bytesRead);
            }
            return bytesRead;
        }
    }

    private static class FtpStorageProgressListener
    implements CopyStreamListener {
        private final StorageProgressListener progressListener;

        FtpStorageProgressListener(StorageProgressListener progressListener) {
            this.progressListener = progressListener;
        }

        @Override
        public void bytesTransferred(CopyStreamEvent copyStreamEvent) {
            this.progressListener.incrementProgress(copyStreamEvent.getBytesTransferred());
        }

        @Override
        public void bytesTransferred(long totalBytesTransferred, int delta, long totalStreamSize) {
            this.progressListener.incrementProgress(delta);
        }
    }
}

