/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.storage;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import ru.dvdishka.backuper.backend.storage.GoogleDriveStorage;
import ru.dvdishka.backuper.backend.storage.exception.StorageConnectionException;

public class GoogleDriveClientProvider {
    private final GoogleDriveStorage storage;
    private Drive driveService = null;
    private final String APPLICATION_NAME = "BACKUPER";
    private final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private final NetHttpTransport NET_HTTP_TRANSPORT = new NetHttpTransport();

    GoogleDriveClientProvider(GoogleDriveStorage storage) {
        this.storage = storage;
    }

    synchronized Drive getClient() throws StorageConnectionException {
        if (this.driveService != null) {
            try {
                ((File)this.driveService.files().get("").setFields("name").execute()).getName();
                return this.driveService;
            }
            catch (Exception ignored) {
                this.driveService = null;
            }
        }
        try {
            Credential credential = this.storage.returnCredentialIfAuthorized();
            if (credential == null) {
                throw new StorageConnectionException(this.storage, "Not authorized in Google Drive!");
            }
            this.driveService = new Drive.Builder(this.NET_HTTP_TRANSPORT, this.JSON_FACTORY, credential).setApplicationName("BACKUPER").setHttpRequestInitializer(httpRequest -> {
                credential.initialize(httpRequest);
                httpRequest.setConnectTimeout(18000000);
                httpRequest.setReadTimeout(18000000);
            }).build();
            return this.driveService;
        }
        catch (Exception e) {
            throw new StorageConnectionException(this.storage, "Not authorized in Google Drive!", e);
        }
    }

    void disconnect() {
        this.driveService = null;
    }
}

