/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.storage;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.api.client.googleapis.media.MediaHttpDownloaderProgressListener;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.client.fluent.Request;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.BackupManager;
import ru.dvdishka.backuper.backend.config.GoogleDriveConfig;
import ru.dvdishka.backuper.backend.storage.GoogleDriveClientProvider;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.storage.StorageType;
import ru.dvdishka.backuper.backend.storage.UserAuthStorage;
import ru.dvdishka.backuper.backend.storage.exception.StorageConnectionException;
import ru.dvdishka.backuper.backend.storage.exception.StorageLimitException;
import ru.dvdishka.backuper.backend.storage.exception.StorageMethodException;
import ru.dvdishka.backuper.backend.storage.exception.StorageQuotaExceededException;
import ru.dvdishka.backuper.backend.storage.util.Retriable;
import ru.dvdishka.backuper.backend.storage.util.StorageProgressInputStream;
import ru.dvdishka.backuper.backend.storage.util.StorageProgressListener;
import ru.dvdishka.backuper.backend.util.ObfuscateUtils;
import ru.dvdishka.backuper.backend.util.UIUtils;

public class GoogleDriveStorage
implements UserAuthStorage {
    private String id = null;
    private final GoogleDriveConfig config;
    private final BackupManager backupManager;
    private Credential credential = null;
    private final GoogleDriveClientProvider mainClient;
    private static final String AUTH_SERVICE_URL = "https://auth.backuper-mc.com";
    private static final String APPLICATION_NAME = "BACKUPER";
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private static final List<String> DRIVE_SCOPES = List.of("https://www.googleapis.com/auth/drive.file");
    private static final NetHttpTransport NET_HTTP_TRANSPORT = new NetHttpTransport();
    private static final String FOLDER_MIME_TYPE = "application/vnd.google-apps.folder";
    Cache<Pair<String, String>, List<File>> cacheLs = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).expireAfterAccess(5L, TimeUnit.SECONDS).build();
    private final Retriable.RetriableExceptionHandler retriableExceptionHandler = new Retriable.RetriableExceptionHandler(){
        final int RATE_LIMIT_DELAY_MILLIS = 10000;

        @Override
        public void handleRegularException(Exception e) throws StorageMethodException, StorageConnectionException, StorageLimitException, StorageQuotaExceededException {
            GoogleJsonResponseException googleJsonResponseException;
            if (e instanceof GoogleJsonResponseException && (googleJsonResponseException = (GoogleJsonResponseException)e).getDetails().getErrors() != null && googleJsonResponseException.getDetails().getErrors().stream().anyMatch(errorInfo -> errorInfo.getReason().equals("rateLimitExceeded"))) {
                Backuper.getInstance().getLogManager().devWarn("Rate limit exceeded, retry in %s seconds...".formatted(10));
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public RuntimeException handleFinalException(Exception e) throws StorageMethodException, StorageConnectionException, StorageLimitException, StorageQuotaExceededException {
            if (e instanceof GoogleJsonResponseException) {
                GoogleJsonResponseException googleJsonResponseException = (GoogleJsonResponseException)e;
                if (googleJsonResponseException.getDetails().getCode() == 401) {
                    return new StorageConnectionException(this.getStorage(), "Failed to authorize user in Google Drive");
                }
                if (googleJsonResponseException.getDetails().getErrors() != null) {
                    if (googleJsonResponseException.getDetails().getErrors().stream().anyMatch(errorInfo -> errorInfo.getReason().equals("storageQuotaExceeded"))) {
                        return new StorageLimitException(this.getStorage(), "Storage limit exceeded");
                    }
                    if (googleJsonResponseException.getDetails().getErrors().stream().anyMatch(errorInfo -> errorInfo.getReason().equals("rateLimitExceeded"))) {
                        Backuper.getInstance().getLogManager().devWarn("Rate limit exceeded, retry in %s seconds...".formatted(10));
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return new StorageQuotaExceededException(this.getStorage(), "Storage quota limit exceeded");
                    }
                }
            }
            return new StorageMethodException(this.getStorage(), e.getMessage(), e);
        }

        public Storage getStorage() {
            return GoogleDriveStorage.this;
        }
    };

    public GoogleDriveStorage(GoogleDriveConfig config) {
        this.config = config;
        this.backupManager = new BackupManager(this);
        this.mainClient = new GoogleDriveClientProvider(this);
    }

    @Override
    public void authorizeForced(CommandSender sender) throws StorageConnectionException {
        try {
            this.credential = null;
            GoogleClientSecrets clientSecrets = JSON_FACTORY.fromString(ObfuscateUtils.decrypt(IOUtils.toString(Backuper.getInstance().getResource("google_cred.txt"))), GoogleClientSecrets.class);
            GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(NET_HTTP_TRANSPORT, JSON_FACTORY, clientSecrets, DRIVE_SCOPES).setDataStoreFactory(new FileDataStoreFactory(this.config.getTokenFolder())).setAccessType("offline").setApprovalPrompt("force").build();
            this.credential = new MyAuthorizationCodeInstalledApp(this, flow).authorize(this.id, true, sender);
            if (this.credential == null) {
                throw new StorageConnectionException(this, "Failed to authorize user in %s storage".formatted(this.id));
            }
            Component header = Component.empty().append((Component)Component.text((String)"Account linking"));
            Component message = Component.empty().append((Component)Component.text((String)"Account has been successfully linked to %s storage".formatted(this.id)));
            UIUtils.sendFramedMessage(header, message, sender);
        }
        catch (Exception e) {
            Component header = Component.empty().append((Component)Component.text((String)"Account linking"));
            Component message = Component.empty().append(Component.text((String)"Failed to link account to %s storage:".formatted(this.id)).color((TextColor)NamedTextColor.RED));
            UIUtils.sendFramedMessage(header, message, sender);
            throw new StorageConnectionException(this, "Failed to authorize user in %s storage".formatted(this.id), e);
        }
    }

    Credential returnCredentialIfAuthorized() throws StorageConnectionException {
        try {
            boolean checkConnection = this.credential == null;
            GoogleClientSecrets clientSecrets = JSON_FACTORY.fromString(ObfuscateUtils.decrypt(IOUtils.toString(Backuper.getInstance().getResource("google_cred.txt"))), GoogleClientSecrets.class);
            GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(NET_HTTP_TRANSPORT, JSON_FACTORY, clientSecrets, DRIVE_SCOPES).setDataStoreFactory(new FileDataStoreFactory(this.config.getTokenFolder())).setApprovalPrompt("force").setAccessType("offline").build();
            this.credential = flow.loadCredential(this.id);
            if (this.credential != null && (this.credential.getRefreshToken() != null || this.credential.getExpiresInSeconds() == null || this.credential.getExpiresInSeconds() > 60L)) {
                if (checkConnection) {
                    try {
                        Drive service = new Drive.Builder(NET_HTTP_TRANSPORT, JSON_FACTORY, this.credential).setApplicationName(APPLICATION_NAME).setHttpRequestInitializer(httpRequest -> {
                            this.credential.initialize(httpRequest);
                            httpRequest.setConnectTimeout(18000000);
                            httpRequest.setReadTimeout(18000000);
                        }).build();
                        File driveFile = (File)service.files().get("").execute();
                        driveFile.getName();
                    }
                    catch (GoogleJsonResponseException e) {
                        if (e.getStatusCode() != 404) {
                            this.credential = null;
                            return null;
                        }
                    }
                    catch (Exception e) {
                        this.credential = null;
                        return null;
                    }
                }
                return this.credential;
            }
            this.credential = null;
            return null;
        }
        catch (Exception e) {
            this.credential = null;
            throw new StorageConnectionException(this, "Failed to authorize user in Google Drive", e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public StorageType getType() {
        return StorageType.GOOGLE_DRIVE;
    }

    @Override
    public GoogleDriveConfig getConfig() {
        return this.config;
    }

    @Override
    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    @Override
    public boolean checkConnection() {
        return this.checkConnection(null);
    }

    @Override
    public boolean checkConnection(CommandSender sender) {
        try {
            this.mainClient.getClient();
            return true;
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().warn("Not authorized in Google Drive", sender);
            Backuper.getInstance().getLogManager().warn(e);
            return false;
        }
    }

    public void addProperty(String fileId, String key, String value) throws StorageQuotaExceededException, StorageMethodException, StorageConnectionException {
        ((Retriable<Void>)() -> {
            Drive service = this.mainClient.getClient();
            Map<String, String> appProperties = ((File)service.files().get(fileId).setFields("appProperties").execute()).getAppProperties();
            appProperties.put(key, value);
            service.files().update(fileId, new File().setAppProperties(appProperties)).setFields("appProperties").execute();
            this.cacheLs.invalidateAll();
            return null;
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public List<String> ls(String driveFileId) throws StorageQuotaExceededException {
        return this.ls(driveFileId, null).stream().map(File::getName).distinct().toList();
    }

    public List<File> ls(String driveFileId, String query) throws StorageQuotaExceededException, StorageMethodException, StorageConnectionException {
        try {
            return this.cacheLs.get(Pair.of(driveFileId, query), () -> ((Retriable<List>)() -> {
                FileList driveFileList;
                String pageToken = null;
                ArrayList<File> driveFiles = new ArrayList<File>();
                Drive service = this.mainClient.getClient();
                do {
                    Drive.Files.List lsRequest = service.files().list().setFields("nextPageToken, files(id, name)").setPageSize(1000).setPageToken(pageToken);
                    String q = "appProperties has { key='backuper' and value='true' }";
                    if (query != null) {
                        q = "%s and %s".formatted(q, query);
                    }
                    if (driveFileId != null && driveFileId.equals("drive")) {
                        lsRequest = lsRequest.setSpaces("drive");
                    }
                    if (driveFileId != null && !driveFileId.isEmpty() && !driveFileId.equals("drive")) {
                        q = "%s and '%s' in parents".formatted(q, driveFileId);
                    }
                    lsRequest = lsRequest.setQ(q);
                    driveFileList = (FileList)lsRequest.execute();
                    driveFiles.addAll(driveFileList.getFiles());
                } while ((pageToken = driveFileList.getNextPageToken()) != null);
                return driveFiles;
            }).retry(this.retriableExceptionHandler));
        }
        catch (ExecutionException e) {
            throw new StorageMethodException(this, "Execution exception on ls", e);
        }
    }

    @Override
    public String resolve(String path, String fileName) {
        if (fileName.isEmpty()) {
            return path;
        }
        File file = this.getFileByName(fileName, path);
        if (file == null) {
            return null;
        }
        return file.getId();
    }

    @Override
    public boolean exists(String path) throws StorageMethodException, StorageConnectionException {
        try {
            Drive service = this.mainClient.getClient();
            ((File)service.files().get(path).setFields("mimeType").execute()).getMimeType().equals(FOLDER_MIME_TYPE);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public long getDirByteSize(String path) throws StorageQuotaExceededException, StorageMethodException, StorageConnectionException {
        return ((Retriable<Long>)() -> {
            if (this.isDir(path)) {
                long size = 0L;
                List<String> files = this.ls(path);
                for (String file : files) {
                    size += this.getDirByteSize(this.getFileByName(file, path).getId());
                }
                return size;
            }
            Drive service = this.mainClient.getClient();
            File driveFile = (File)service.files().get(path).setFields("size").execute();
            Long size = driveFile.getSize();
            return size != null ? size : 0L;
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public boolean isFile(String driveFileId) throws StorageMethodException, StorageConnectionException, StorageQuotaExceededException {
        return ((Retriable<Boolean>)() -> {
            Drive service = this.mainClient.getClient();
            return !((File)service.files().get(driveFileId).setFields("mimeType").execute()).getMimeType().equals(FOLDER_MIME_TYPE);
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public String getFileNameFromPath(String path) throws StorageMethodException, StorageConnectionException {
        return ((Retriable<String>)() -> ((File)this.mainClient.getClient().files().get(path).setFields("name").execute()).getName()).retry(this.retriableExceptionHandler);
    }

    @Override
    public String getParentPath(String path) throws StorageMethodException, StorageConnectionException {
        return ((Retriable<String>)() -> ((File)this.mainClient.getClient().files().get(path).setFields("parents").execute()).getParents().getFirst()).retry(this.retriableExceptionHandler);
    }

    public File getFileByName(String fileName, String parentId) throws StorageQuotaExceededException, StorageMethodException, StorageConnectionException {
        return ((Retriable<File>)() -> {
            Drive service = this.mainClient.getClient();
            Object q = "";
            q = (String)q + "name = '%s'".formatted(fileName);
            q = (String)q + " and appProperties has { key='backuper' and value='true' }";
            Drive.Files.List lsRequest = service.files().list();
            if (parentId != null && !parentId.isEmpty()) {
                q = (String)q + " and '%s' in parents".formatted(parentId);
            }
            lsRequest.setQ((String)q);
            lsRequest.setFields("files(mimeType, size, name, id, parents, appProperties)");
            FileList driveFileList = (FileList)lsRequest.execute();
            return !driveFileList.getFiles().isEmpty() ? driveFileList.getFiles().getFirst() : null;
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public void createDir(String folderName, String parentFolderId) throws StorageQuotaExceededException, StorageLimitException, StorageMethodException, StorageConnectionException {
        this.createDir(folderName, parentFolderId, new HashMap<String, String>());
    }

    public void createDir(String folderName, String parentFolderId, Map<String, String> properties) throws StorageQuotaExceededException, StorageLimitException, StorageMethodException, StorageConnectionException {
        ((Retriable<Void>)() -> {
            Drive service = this.mainClient.getClient();
            properties.put("backuper", "true");
            File driveFileMeta = new File();
            driveFileMeta.setName(folderName);
            driveFileMeta.setAppProperties(properties);
            if (!Objects.equals(parentFolderId, "")) {
                driveFileMeta.setParents(List.of(parentFolderId));
            }
            driveFileMeta.setMimeType(FOLDER_MIME_TYPE);
            service.files().create(driveFileMeta).execute();
            this.cacheLs.invalidateAll();
            return null;
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public void uploadFile(InputStream sourceStream, String newFileName, String targetParentDir, StorageProgressListener progressListener) throws StorageMethodException, StorageConnectionException, StorageLimitException, StorageQuotaExceededException {
        ((Retriable<Void>)() -> {
            Drive service = this.mainClient.getClient();
            HashMap<String, String> fileAppProperties = new HashMap<String, String>();
            fileAppProperties.put("backuper", "true");
            File driveFileMeta = new File();
            driveFileMeta.setAppProperties(fileAppProperties);
            driveFileMeta.setName(newFileName);
            if (!Objects.equals(targetParentDir, "")) {
                driveFileMeta.setParents(List.of(targetParentDir));
            }
            InputStreamContent contentStream = new InputStreamContent("", new StorageProgressInputStream(sourceStream, progressListener));
            contentStream.setCloseInputStream(false);
            Drive.Files.Create driveFileCreate = service.files().create(driveFileMeta, contentStream).setUploadType("resumable").setFields("id, parents, appProperties");
            driveFileCreate.getMediaHttpUploader().setChunkSize(0xA00000);
            driveFileCreate.execute();
            this.cacheLs.invalidateAll();
            return null;
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public InputStream downloadFile(String sourcePath, StorageProgressListener progressListener) throws StorageQuotaExceededException, StorageMethodException, StorageConnectionException {
        return ((Retriable<InputStream>)() -> {
            Drive service = this.mainClient.getClient();
            Drive.Files.Get getDriveFile = service.files().get(sourcePath);
            getDriveFile.getMediaHttpDownloader().setChunkSize(0x2000000);
            return new StorageProgressInputStream(getDriveFile.executeMediaAsInputStream(), progressListener);
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public void delete(String id) throws StorageQuotaExceededException, StorageMethodException, StorageConnectionException {
        ((Retriable<Void>)() -> {
            Drive service = this.mainClient.getClient();
            service.files().delete(id).execute();
            this.cacheLs.invalidateAll();
            return null;
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public void renameFile(String fileId, String newFileName) throws StorageQuotaExceededException, StorageMethodException, StorageConnectionException {
        ((Retriable<Void>)() -> {
            Drive service = this.mainClient.getClient();
            service.files().update(fileId, new File().setName(newFileName)).setFields("name").execute();
            this.cacheLs.invalidateAll();
            return null;
        }).retry(this.retriableExceptionHandler);
    }

    @Override
    public int getStorageSpeedMultiplier() {
        return 15;
    }

    @Override
    public void destroy() {
        this.mainClient.disconnect();
        this.credential = null;
    }

    @Override
    public void downloadCompleted() throws StorageMethodException, StorageConnectionException {
    }

    @Override
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    private static class MyAuthorizationCodeInstalledApp {
        private final Storage storage;
        private final AuthorizationCodeFlow flow;

        public MyAuthorizationCodeInstalledApp(Storage storage, AuthorizationCodeFlow flow) {
            this.storage = storage;
            this.flow = flow;
        }

        protected void onAuthorization(String id, CommandSender sender) {
            String url = "%s/authgd?id=%s".formatted(GoogleDriveStorage.AUTH_SERVICE_URL, id);
            Component header = Component.empty().append((Component)Component.text((String)"Account linking"));
            Component message = ((TextComponent)Component.empty().append((Component)Component.space())).append(((TextComponent)Component.text((String)url).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.OPEN_URL, (String)url))).decorate(TextDecoration.UNDERLINED));
            UIUtils.sendFramedMessage(header, message, sender);
        }

        public Credential authorize(String userId, boolean force, CommandSender sender) {
            int t2;
            if (!force) {
                try {
                    Credential credential = this.flow.loadCredential(userId);
                    if (credential != null && (credential.getRefreshToken() != null || credential.getExpiresInSeconds() == null || credential.getExpiresInSeconds() > 60L)) {
                        return credential;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load Google Drive credentials", e);
                }
            }
            String id = userId + this.generateId();
            this.onAuthorization(id, sender);
            String response = null;
            try {
                for (t2 = 0; t2 < 300; ++t2) {
                    String result;
                    try {
                        result = Request.Get("%s/getgd?id=%s".formatted(GoogleDriveStorage.AUTH_SERVICE_URL, id)).execute().returnContent().asString();
                    }
                    catch (Exception e) {
                        throw new StorageConnectionException(this.storage, "Failed to connect to AuthGD or AuthGD is down.Please let the developer know if you are sure that your network connection is ok", e);
                    }
                    if (!result.equals("null") && !result.equals("wrong")) {
                        response = result;
                        break;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                throw new StorageConnectionException(this.storage, "Failed to get authGD server response", e);
            }
            if (t2 >= 300) {
                throw new StorageConnectionException(this.storage, "AuthGD response timeout");
            }
            Gson gson = new GsonBuilder().create();
            HashMap responseJson = gson.fromJson(response, HashMap.class);
            TokenResponse tokenResponse = new TokenResponse();
            tokenResponse.setAccessToken((String)responseJson.get("access_token"));
            tokenResponse.setScope((String)responseJson.get("scope"));
            tokenResponse.setTokenType((String)responseJson.get("token_type"));
            tokenResponse.setTokenType((String)responseJson.get("token_type"));
            tokenResponse.setExpiresInSeconds(((Double)responseJson.get("expires_in")).longValue());
            tokenResponse.setRefreshToken((String)responseJson.get("refresh_token"));
            try {
                return this.flow.createAndStoreCredential(tokenResponse, userId);
            }
            catch (IOException e) {
                throw new StorageConnectionException(this.storage, "Failed to save Google Drive credentials", e);
            }
        }

        private String generateId() {
            StringBuilder id = new StringBuilder();
            Random rand = new Random();
            for (int i = 0; i < 16; ++i) {
                int r = rand.nextInt(0, 62);
                if (r < 10) {
                    id.append((char)(48 + r));
                    continue;
                }
                if (r - 10 < 26) {
                    id.append((char)(65 + r - 10));
                    continue;
                }
                id.append((char)(97 + r - 36));
            }
            return id.toString();
        }
    }

    private static class GoogleDriveStorageProgressListener
    implements MediaHttpUploaderProgressListener,
    MediaHttpDownloaderProgressListener {
        private final StorageProgressListener progressListener;
        long progress = 0L;

        public GoogleDriveStorageProgressListener(StorageProgressListener progressListener) {
            this.progressListener = progressListener;
        }

        @Override
        public void progressChanged(MediaHttpUploader mediaHttpUploader) {
            this.progressListener.incrementProgress(mediaHttpUploader.getNumBytesUploaded() - this.progress);
            this.progress = mediaHttpUploader.getNumBytesUploaded();
        }

        @Override
        public void progressChanged(MediaHttpDownloader mediaHttpDownloader) {
            this.progressListener.incrementProgress(mediaHttpDownloader.getNumBytesDownloaded() - this.progress);
            this.progress = mediaHttpDownloader.getNumBytesDownloaded();
        }
    }
}

