/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.storage;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.util.Properties;
import ru.dvdishka.backuper.backend.storage.SftpStorage;
import ru.dvdishka.backuper.backend.storage.exception.StorageConnectionException;

public class SftpClientProvider {
    private final SftpStorage storage;
    private Session sshSession = null;
    private ChannelSftp sftpChannel = null;

    SftpClientProvider(SftpStorage storage) {
        this.storage = storage;
    }

    synchronized ChannelSftp getClient() {
        if (this.sshSession != null && this.sftpChannel != null) {
            try {
                if (this.sftpChannel.isConnected() && this.sftpChannel.pwd() != null) {
                    return this.sftpChannel;
                }
                this.sftpChannel.connect();
            }
            catch (Exception ignored) {
                this.connect();
                try {
                    if (this.sftpChannel.isConnected() && this.sftpChannel.pwd() != null) {
                        return this.sftpChannel;
                    }
                    throw new StorageConnectionException(this.storage, "Failed to connect to establish sftp connection");
                }
                catch (SftpException e) {
                    throw new StorageConnectionException(this.storage, "Failed to connect to establish sftp connection", e);
                }
            }
        }
        this.connect();
        try {
            if (this.sftpChannel.isConnected() && this.sftpChannel.pwd() != null) {
                return this.sftpChannel;
            }
            throw new StorageConnectionException(this.storage, "Failed to connect to establish sftp connection");
        }
        catch (SftpException e) {
            throw new StorageConnectionException(this.storage, "Failed to connect to establish sftp connection", e);
        }
    }

    private void connect() {
        if (!(this.storage.getConfig().getAuthType().equals("password") || this.storage.getConfig().getAuthType().equals("key") || this.storage.getConfig().getAuthType().equals("key_pass"))) {
            throw new StorageConnectionException(this.storage, "Wrong auth type \"%s\"".formatted(this.storage.getConfig().getAuthType()));
        }
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp channel = null;
        try {
            if (!this.storage.getConfig().getSshConfigFilePath().isEmpty()) {
                jsch.setConfigRepository(OpenSSHConfig.parseFile(this.storage.getConfig().getSshConfigFilePath()));
            } else {
                if (this.storage.getConfig().getAuthType().equals("key")) {
                    jsch.addIdentity(this.storage.getConfig().getKeyFilePath());
                }
                if (this.storage.getConfig().getAuthType().equals("key_pass")) {
                    jsch.addIdentity(this.storage.getConfig().getKeyFilePath(), this.storage.getConfig().getPassword());
                }
                session = jsch.getSession(this.storage.getConfig().getUsername(), this.storage.getConfig().getAddress(), this.storage.getConfig().getPort());
                if (this.storage.getConfig().getAuthType().equals("password")) {
                    session.setPassword(this.storage.getConfig().getPassword());
                }
                Properties properties = new Properties();
                if (this.storage.getConfig().getUseKnownHostsFile().equals("false")) {
                    properties.put("StrictHostKeyChecking", "no");
                } else {
                    properties.put("StrictHostKeyChecking", "yes");
                }
                session.setConfig(properties);
                if (!this.storage.getConfig().getUseKnownHostsFile().equals("false")) {
                    jsch.setKnownHosts(this.storage.getConfig().getKnownHostsFilePath());
                }
                session.connect(15000);
                session.setServerAliveInterval(60000);
                channel = (ChannelSftp)session.openChannel("sftp");
                channel.connect(15000);
                this.sshSession = session;
                this.sftpChannel = channel;
            }
        }
        catch (Exception e) {
            try {
                if (channel != null) {
                    channel.exit();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (session != null) {
                    session.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new StorageConnectionException(this.storage, "Failed to establish SFTP connection", e);
        }
    }

    void disconnect() {
        if (this.sftpChannel != null) {
            try {
                this.sftpChannel.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.sshSession.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sftpChannel = null;
        this.sshSession = null;
    }
}

