/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.storage;

import java.io.InputStream;
import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.backend.backup.BackupManager;
import ru.dvdishka.backuper.backend.config.StorageConfig;
import ru.dvdishka.backuper.backend.storage.StorageType;
import ru.dvdishka.backuper.backend.storage.exception.StorageConnectionException;
import ru.dvdishka.backuper.backend.storage.exception.StorageLimitException;
import ru.dvdishka.backuper.backend.storage.exception.StorageMethodException;
import ru.dvdishka.backuper.backend.storage.util.BasicStorageProgressListener;
import ru.dvdishka.backuper.backend.storage.util.StorageProgressListener;

public interface Storage {
    public void setId(String var1);

    public String getId();

    public StorageType getType();

    public StorageConfig getConfig();

    public BackupManager getBackupManager();

    public boolean checkConnection();

    public boolean checkConnection(CommandSender var1);

    public List<String> ls(String var1) throws StorageMethodException, StorageConnectionException;

    public String resolve(String var1, String var2) throws StorageMethodException;

    public boolean exists(String var1) throws StorageMethodException, StorageConnectionException;

    public boolean isFile(String var1) throws StorageMethodException, StorageConnectionException;

    default public boolean isDir(String path) throws StorageMethodException, StorageConnectionException {
        return !this.isFile(path);
    }

    public String getFileNameFromPath(String var1) throws StorageMethodException, StorageConnectionException;

    public String getParentPath(String var1) throws StorageMethodException, StorageConnectionException;

    public long getDirByteSize(String var1) throws StorageMethodException, StorageConnectionException;

    public void createDir(String var1, String var2) throws StorageLimitException, StorageMethodException, StorageConnectionException;

    public void uploadFile(InputStream var1, String var2, String var3, StorageProgressListener var4) throws StorageLimitException, StorageMethodException, StorageConnectionException;

    default public void uploadFile(InputStream sourceStream, String newFileName, String targetParentDir) throws StorageLimitException, StorageMethodException, StorageConnectionException {
        this.uploadFile(sourceStream, newFileName, targetParentDir, new BasicStorageProgressListener());
    }

    public InputStream downloadFile(String var1, StorageProgressListener var2) throws StorageMethodException, StorageConnectionException;

    default public InputStream downloadFile(String sourcePath) throws StorageMethodException, StorageConnectionException {
        return this.downloadFile(sourcePath, new BasicStorageProgressListener());
    }

    public void downloadCompleted() throws StorageMethodException, StorageConnectionException;

    public void delete(String var1) throws StorageMethodException, StorageConnectionException;

    public void renameFile(String var1, String var2) throws StorageMethodException, StorageConnectionException;

    public int getStorageSpeedMultiplier();

    default public int getDeleteProgressMultiplier() {
        return this.getStorageSpeedMultiplier();
    }

    default public int getTransferProgressMultiplier() {
        return this.getStorageSpeedMultiplier() * 5;
    }

    default public int getZipProgressMultiplier() {
        return this.getStorageSpeedMultiplier() * 10;
    }

    public void destroy();
}

