/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.config.LocalConfig;
import ru.dvdishka.backuper.backend.storage.LocalStorage;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.storage.UserAuthStorage;
import ru.dvdishka.backuper.backend.util.UIUtils;
import ru.dvdishka.backuper.handlers.commands.list.ListCommand;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class StorageManager
implements Listener {
    private final HashMap<String, Storage> storages = new HashMap();
    private final Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();

    public StorageManager() {
        LocalConfig config = new LocalConfig();
        LocalStorage storage = new LocalStorage(config.load(config.getDefaultConfig(), "backuper"));
        this.registerStorage("backuper", storage);
    }

    public void registerStorage(String id, Storage storage) throws RuntimeException {
        if (this.storages.containsKey(id)) {
            throw new RuntimeException("\"%s\" id is already used for some storage".formatted(id));
        }
        storage.setId(id);
        this.storages.put(id, storage);
    }

    public Storage getStorage(String id) {
        return this.storages.get(id);
    }

    public List<Storage> getStorages() {
        return new ArrayList<Storage>(this.storages.values().stream().filter(storage -> !storage.getId().equals("backuper")).toList());
    }

    public void saveSizeCache() {
        try {
            File sizeCachceFile = Backuper.getInstance().getConfigManager().getServerConfig().getSizeCacheFile();
            FileWriter writer = new FileWriter(sizeCachceFile);
            HashMap<String, ConcurrentMap<String, Long>> jsonedCache = new HashMap<String, ConcurrentMap<String, Long>>();
            for (Storage storage : this.storages.values()) {
                jsonedCache.put(storage.getId(), storage.getBackupManager().getSizeCache());
            }
            String json = this.gson.toJson(jsonedCache);
            writer.write(json);
            writer.close();
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().warn("Failed to save size cache to disk!");
            Backuper.getInstance().getLogManager().warn(e);
        }
    }

    public void loadSizeCache() {
        try {
            int length;
            File sizeCacheFile = Backuper.getInstance().getConfigManager().getServerConfig().getSizeCacheFile();
            try {
                if (!sizeCacheFile.exists() && !sizeCacheFile.createNewFile()) {
                    Backuper.getInstance().getLogManager().warn("Unable to create %s file!".formatted(sizeCacheFile.getPath()));
                }
            }
            catch (Exception e) {
                Backuper.getInstance().getLogManager().warn("Unable to create %s file!".formatted(sizeCacheFile.getPath()));
            }
            FileReader reader = new FileReader(sizeCacheFile);
            StringBuilder json = new StringBuilder();
            char[] buffer = new char[1024];
            while ((length = reader.read(buffer)) != -1) {
                json.append(new String(buffer, 0, length));
            }
            reader.close();
            String jsonString = json.toString();
            if (jsonString.isEmpty()) {
                return;
            }
            Type typeToken = new TypeToken<HashMap<String, HashMap<String, Long>>>(this){}.getType();
            HashMap jsonedCache = (HashMap)this.gson.fromJson(jsonString, typeToken);
            for (Storage storage : this.storages.values()) {
                if (!jsonedCache.containsKey(storage.getId())) continue;
                storage.getBackupManager().loadSizeCache((Map)jsonedCache.get(storage.getId()));
            }
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().warn("Failed to load backups size cache");
            Backuper.getInstance().getLogManager().warn(e);
        }
    }

    public void indexStorages() {
        for (final Storage storage : this.getStorages()) {
            Backuper.getInstance().getScheduleManager().runAsync(() -> {
                try {
                    Backuper.getInstance().getLogManager().devLog("Indexing %s storage...".formatted(storage.getId()));
                    new ListCommand(false, (CommandSender)Bukkit.getConsoleSender(), new CommandArguments(new Object[]{storage.getId()}, (Map<String, Object>)new HashMap<String, Object>(this){
                        final /* synthetic */ StorageManager this$0;
                        {
                            this.this$0 = this$0;
                            this.put("storage", storage.getId());
                        }
                    }, new String[]{storage.getId()}, (Map<String, String>)new HashMap<String, String>(this){
                        final /* synthetic */ StorageManager this$0;
                        {
                            this.this$0 = this$0;
                            this.put("storage", storage.getId());
                        }
                    }, "/backuper list %s".formatted(storage.getId()))).execute();
                    Backuper.getInstance().getLogManager().devLog("%s storage indexing completed".formatted(storage.getId()));
                }
                catch (Exception e) {
                    Backuper.getInstance().getLogManager().warn("Failed to index storage %s".formatted(storage.getId()));
                    Backuper.getInstance().getLogManager().warn(e);
                }
            });
        }
    }

    public void checkStoragesConnection() {
        for (Storage storage : this.storages.values()) {
            if (storage.checkConnection()) {
                Backuper.getInstance().getLogManager().log("Connection to %s storage established successfully".formatted(storage.getId()));
                continue;
            }
            Backuper.getInstance().getLogManager().warn("Failed to establish connection to %s storage".formatted(storage.getId()));
        }
        this.sendUserAuthStoragesCheckResult((CommandSender)Bukkit.getConsoleSender());
    }

    public void destroy() {
        for (Storage storage : this.storages.values()) {
            storage.destroy();
        }
    }

    private void sendUserAuthStoragesCheckResult(CommandSender sender) {
        for (Storage storage : Backuper.getInstance().getStorageManager().getStorages()) {
            if (!(storage instanceof UserAuthStorage) || !sender.isOp() || storage.checkConnection()) continue;
            TextComponent header = Component.empty();
            header = header.append(((TextComponent)Component.text((String)"%s storage account".formatted(storage.getId())).decorate(TextDecoration.BOLD)).color((TextColor)NamedTextColor.RED));
            TextComponent message = Component.empty();
            message = message.append(((TextComponent)Component.text((String)"%s storage is enabled, but account is not linked!".formatted(storage.getId())).decorate(TextDecoration.BOLD)).color((TextColor)NamedTextColor.RED)).append((Component)Component.newline()).append(((TextComponent)Component.text((String)"Use ").decorate(TextDecoration.BOLD)).color((TextColor)NamedTextColor.RED)).append(((TextComponent)Component.text((String)"/backuper account %s link".formatted(storage.getId())).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.suggestCommand((String)"/backuper account %s link".formatted(storage.getId()))));
            UIUtils.sendFramedMessage((Component)header, (Component)message, sender);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.sendUserAuthStoragesCheckResult((CommandSender)event.getPlayer());
    }
}

