/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.storage.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.storage.exception.StorageConnectionException;
import ru.dvdishka.backuper.backend.storage.exception.StorageLimitException;
import ru.dvdishka.backuper.backend.storage.exception.StorageMethodException;
import ru.dvdishka.backuper.backend.storage.exception.StorageQuotaExceededException;

@FunctionalInterface
public interface Retriable<T> {
    public static final int DEFAULT_RETRIES = 5;
    public static final int DEFAULT_RETRY_DELAY_MILLIS = 3000;

    public T run() throws Exception;

    default public T retry(RetriableExceptionHandler exceptionHandler, int retries, int retryDelayMillis) throws StorageMethodException, StorageConnectionException, StorageLimitException, StorageQuotaExceededException {
        int completedRetries = 0;
        while (completedRetries < retries) {
            try {
                return this.run();
            }
            catch (Exception e) {
                if (++completedRetries == retries) {
                    Exception exception = e;
                    Objects.requireNonNull(exception);
                    Exception exception2 = exception;
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StorageConnectionException.class, StorageLimitException.class, StorageQuotaExceededException.class, StorageMethodException.class}, (Object)exception2, n)) {
                        case 0: {
                            StorageConnectionException storageConnectionException = (StorageConnectionException)exception2;
                            throw storageConnectionException;
                        }
                        case 1: {
                            StorageLimitException storageLimitException = (StorageLimitException)exception2;
                            throw storageLimitException;
                        }
                        case 2: {
                            StorageQuotaExceededException storageQuotaExceededException = (StorageQuotaExceededException)exception2;
                            throw storageQuotaExceededException;
                        }
                        case 3: {
                            StorageMethodException storageMethodException = (StorageMethodException)exception2;
                            throw storageMethodException;
                        }
                    }
                    throw exceptionHandler.handleFinalException(e);
                }
                Backuper.getInstance().getLogManager().devWarn("Operation failed, retrying in " + retryDelayMillis / 1000 + " seconds... (" + completedRetries + "/" + retries + ")");
                Backuper.getInstance().getLogManager().devWarn(e);
                if (!(e instanceof StorageLimitException || e instanceof StorageQuotaExceededException || e instanceof StorageConnectionException || e instanceof StorageMethodException)) {
                    exceptionHandler.handleRegularException(e);
                }
                try {
                    Thread.sleep(retryDelayMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw new RuntimeException("Unexpected error in Retriable logic");
    }

    default public T retry(RetriableExceptionHandler exceptionHandler) throws StorageMethodException, StorageConnectionException, StorageLimitException, StorageQuotaExceededException {
        return this.retry(exceptionHandler, 5, 3000);
    }

    public static interface RetriableExceptionHandler {
        public void handleRegularException(Exception var1);

        public RuntimeException handleFinalException(Exception var1);
    }
}

