/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.storage.util;

import java.io.IOException;
import java.io.InputStream;
import ru.dvdishka.backuper.backend.storage.util.StorageProgressListener;

public class StorageProgressInputStream
extends InputStream {
    private final InputStream inputStream;
    private final StorageProgressListener progressListener;

    public StorageProgressInputStream(InputStream inputStream, StorageProgressListener progressListener) {
        this.inputStream = inputStream;
        this.progressListener = progressListener;
    }

    @Override
    public int read() throws IOException {
        int result = this.inputStream.read();
        if (result != -1) {
            this.progressListener.incrementProgress(1L);
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytesRead = this.inputStream.read(b);
        if (bytesRead > 0) {
            this.progressListener.incrementProgress(bytesRead);
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.inputStream.read(b, off, len);
        if (bytesRead > 0) {
            this.progressListener.incrementProgress(bytesRead);
        }
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.inputStream.close();
    }
}

