/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.task.BaseTask;
import ru.dvdishka.backuper.backend.task.TaskException;
import ru.dvdishka.backuper.backend.task.TransferDirTask;

public class CopyToTask
extends BaseTask {
    private final Backup sourceBackup;
    private final Storage targetStorage;
    private TransferDirTask copyToTask;

    public CopyToTask(Backup sourceBackup, Storage targetStorage) {
        this.sourceBackup = sourceBackup;
        this.targetStorage = targetStorage;
    }

    @Override
    public void run() {
        try {
            if (!this.cancelled) {
                Backuper.getInstance().getTaskManager().startTaskRaw(this.copyToTask, this.sender);
                this.targetStorage.renameFile(this.targetStorage.resolve(this.targetStorage.getConfig().getBackupsFolder(), this.sourceBackup.getInProgressFileName()), this.sourceBackup.getFileName());
                this.targetStorage.getBackupManager().saveBackupSizeToCache(this.sourceBackup.getName(), this.sourceBackup.getByteSize());
            }
        }
        catch (Exception e) {
            this.warn(new TaskException(this.copyToTask, (Throwable)e));
        }
    }

    @Override
    public void prepareTask(CommandSender sender) throws Throwable {
        if (this.cancelled) {
            return;
        }
        this.copyToTask = new TransferDirTask(this.sourceBackup.getStorage(), this.sourceBackup.getPath(), this.targetStorage, this.targetStorage.getConfig().getBackupsFolder(), this.sourceBackup.getInProgressFileName(), true);
        this.copyToTask.maxProgress = this.sourceBackup.getByteSize();
        Backuper.getInstance().getTaskManager().prepareTask(this.copyToTask, sender);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        if (this.copyToTask != null) {
            Backuper.getInstance().getTaskManager().cancelTaskRaw(this.copyToTask);
        }
    }

    @Override
    public long getTaskMaxProgress() {
        if (!this.isTaskPrepared()) {
            return 0L;
        }
        return this.copyToTask.getTaskMaxProgress() * Long.max(this.sourceBackup.getStorage().getTransferProgressMultiplier(), this.targetStorage.getTransferProgressMultiplier());
    }

    @Override
    public long getTaskCurrentProgress() {
        if (!this.isTaskPrepared()) {
            return 0L;
        }
        return this.copyToTask.getTaskCurrentProgress() * Long.max(this.sourceBackup.getStorage().getTransferProgressMultiplier(), this.targetStorage.getTransferProgressMultiplier());
    }
}

