/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.task.BackupDeleteTask;
import ru.dvdishka.backuper.backend.task.BaseTask;
import ru.dvdishka.backuper.backend.task.Task;
import ru.dvdishka.backuper.backend.task.TaskException;

public class DeleteOldBackupsTask
extends BaseTask {
    private final ArrayList<Task> tasks = new ArrayList();

    @Override
    public void run() {
        for (Task deleteDirTask : this.tasks) {
            if (this.cancelled) continue;
            try {
                Backuper.getInstance().getTaskManager().startTaskRaw(deleteDirTask, this.sender);
            }
            catch (Exception e) {
                this.warn(new TaskException(deleteDirTask, (Throwable)e));
            }
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (Task task : this.tasks) {
            Backuper.getInstance().getTaskManager().cancelTaskRaw(task);
        }
    }

    @Override
    public void prepareTask(CommandSender sender) {
        block6: for (Storage storage : Backuper.getInstance().getStorageManager().getStorages()) {
            if (this.cancelled || storage.getConfig().getBackupsNumber() == 0 && storage.getConfig().getBackupsWeight() == 0L) {
                return;
            }
            HashSet<LocalDateTime> backupsToDeleteList = new HashSet<LocalDateTime>();
            long backupsFolderByteSize = 0L;
            ArrayList<Backup> backups = new ArrayList<Backup>(storage.getBackupManager().getBackupList());
            if (this.cancelled) {
                return;
            }
            for (Backup backup : backups) {
                if (this.cancelled) {
                    return;
                }
                try {
                    backupsFolderByteSize += backup.getByteSize();
                }
                catch (Exception e) {
                    this.warn("Failed to get \"%s\" backup byte size in %s storage".formatted(backup.getName(), storage.getId()), sender);
                    this.warn(e);
                }
            }
            List<LocalDateTime> backupDateTimes = backups.stream().map(Backup::getLocalDateTime).sorted().toList();
            if (storage.getConfig().getBackupsNumber() != 0) {
                int backupsToDelete = backups.size() - storage.getConfig().getBackupsNumber();
                for (LocalDateTime fileName : backupDateTimes) {
                    if (backupsToDelete <= 0) break;
                    if (backupsToDeleteList.contains(fileName)) continue;
                    for (Backup backup : backups) {
                        if (this.cancelled) {
                            return;
                        }
                        String backupFileName = backup.getName().replace(".zip", "");
                        try {
                            if (!LocalDateTime.parse(backupFileName, Backuper.getInstance().getConfigManager().getBackupConfig().getDateTimeFormatter()).equals(fileName)) continue;
                            BackupDeleteTask deleteBackupTask = backup.getDeleteTask();
                            Backuper.getInstance().getTaskManager().prepareTask(deleteBackupTask, sender);
                            this.tasks.add(deleteBackupTask);
                            backupsToDeleteList.add(fileName);
                            backupsFolderByteSize -= backup.getByteSize();
                        }
                        catch (Throwable e) {
                            Backuper.getInstance().getLogManager().warn(new RuntimeException(e));
                        }
                    }
                    --backupsToDelete;
                }
            }
            if (storage.getConfig().getBackupsWeight() == 0L) continue;
            long bytesToDelete = backupsFolderByteSize - storage.getConfig().getBackupsWeight();
            for (LocalDateTime fileName : backupDateTimes) {
                if (bytesToDelete <= 0L) continue block6;
                if (backupsToDeleteList.contains(fileName)) continue;
                for (Backup backup : backups) {
                    if (this.cancelled) {
                        return;
                    }
                    String backupFileName = backup.getName().replace(".zip", "");
                    try {
                        if (!LocalDateTime.parse(backupFileName, Backuper.getInstance().getConfigManager().getBackupConfig().getDateTimeFormatter()).equals(fileName)) continue;
                        bytesToDelete -= backup.getByteSize();
                        BackupDeleteTask deleteBackupTask = backup.getDeleteTask();
                        Backuper.getInstance().getTaskManager().prepareTask(deleteBackupTask, sender);
                        this.tasks.add(deleteBackupTask);
                        backupsToDeleteList.add(fileName);
                    }
                    catch (Throwable e) {
                        Backuper.getInstance().getLogManager().warn(new RuntimeException(e));
                    }
                }
            }
        }
    }

    @Override
    public long getTaskCurrentProgress() {
        return this.tasks.stream().mapToLong(Task::getTaskCurrentProgress).sum();
    }

    @Override
    public long getTaskMaxProgress() {
        return this.tasks.stream().mapToLong(Task::getTaskMaxProgress).sum();
    }
}

