/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.task;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.task.Task;
import ru.dvdishka.backuper.backend.task.TaskException;
import ru.dvdishka.backuper.backend.util.UIUtils;

public class TaskManager {
    private Task currentTask;
    private List<String> currentTaskPermissions;
    boolean forceLock = false;

    private Result start(Task task, CommandSender sender, List<String> permissions, Function<Runnable, CompletableFuture<Void>> taskExecutor) {
        if (this.isLocked()) {
            return Result.LOCKED.sendMessage(task, sender);
        }
        if (!this.hasPermissions(permissions, sender)) {
            return Result.NO_PERMISSION.sendMessage(task, sender);
        }
        this.currentTask = task;
        this.currentTaskPermissions = permissions;
        Result.STARTED.sendMessage(task, sender);
        CompletableFuture<Void> taskFuture = taskExecutor.apply(() -> {
            try {
                Backuper.getInstance().getTaskManager().startTaskRaw(this.currentTask, sender);
            }
            catch (Exception e) {
                Backuper.getInstance().getLogManager().warn("An error occurred while executing task %s".formatted(task.getTaskName()));
                Backuper.getInstance().getLogManager().warn(e);
            }
            this.currentTaskPermissions = null;
            this.currentTask = null;
            Result.COMPLETED.sendMessage(task, sender);
        });
        task.setTaskFuture(taskFuture);
        if (taskFuture.isDone()) {
            return Result.COMPLETED;
        }
        return Result.STARTED;
    }

    public Result startTask(Task task, CommandSender sender, List<String> permissions) {
        return this.start(task, sender, permissions, runnable -> {
            runnable.run();
            return CompletableFuture.completedFuture(null);
        });
    }

    public Result startTaskAsync(Task task, CommandSender sender, List<String> permissions) {
        return this.start(task, sender, permissions, Backuper.getInstance().getScheduleManager()::runAsync);
    }

    public void startTaskRaw(Task task, CommandSender sender) throws TaskException {
        Backuper.getInstance().getLogManager().devLog("Task %s started".formatted(task.getTaskName()));
        task.start(sender);
        Backuper.getInstance().getLogManager().devLog("Task %s completed".formatted(task.getTaskName()));
    }

    public void cancelTaskRaw(Task task) {
        task.cancel();
        if (task.getPrepareTaskFuture() != null) {
            try {
                task.getPrepareTaskFuture().cancel(false);
                task.getPrepareTaskFuture().join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (task.getTaskFuture() != null) {
            try {
                task.getTaskFuture().cancel(false);
                task.getTaskFuture().join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void prepareTask(Task task, CommandSender sender) throws Throwable {
        CompletableFuture<Void> prepareTaskFuture = Backuper.getInstance().getScheduleManager().runAsync(() -> {
            Backuper.getInstance().getLogManager().devLog("Preparing task %s".formatted(task.getTaskName()));
            try {
                task.prepareTask(sender);
            }
            catch (Throwable e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    Backuper.getInstance().getLogManager().devLog("%s task preparation completed".formatted(task.getTaskName()));
                    throw throwable;
                }
            }
            Backuper.getInstance().getLogManager().devLog("%s task preparation completed".formatted(task.getTaskName()));
        });
        task.setPrepareTaskFuture(prepareTaskFuture);
        try {
            prepareTaskFuture.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            throw e.getCause().getCause();
        }
    }

    public Result cancelCurrentTask(CommandSender sender) {
        if (this.currentTask == null) {
            return Result.NO_TASK_RUNNING.sendMessage(null, sender);
        }
        if (!this.hasPermissions(this.currentTaskPermissions, sender)) {
            return Result.NO_PERMISSION.sendMessage(this.currentTask, sender);
        }
        this.sendCancellingMessage(sender);
        this.cancelTaskRaw(this.currentTask);
        return Result.CANCELLED;
    }

    public boolean isLocked() {
        return this.currentTask != null && !this.forceLock;
    }

    private boolean hasPermissions(List<String> permissions, CommandSender sender) {
        return permissions.stream().allMatch(arg_0 -> ((CommandSender)sender).hasPermission(arg_0));
    }

    private void sendCancellingMessage(CommandSender sender) {
        Backuper.getInstance().getLogManager().log("Cancelling %s task...".formatted(this.currentTask.getTaskName()), sender);
    }

    public void forceLock() {
        this.forceLock = true;
    }

    public void forceUnlock() {
        this.forceLock = false;
    }

    @Generated
    public Task getCurrentTask() {
        return this.currentTask;
    }

    public static enum Result {
        STARTED(""),
        COMPLETED(""),
        CANCELLED("%s task has been successfully cancelled"),
        NO_PERMISSION("You don't have enough permissions"),
        LOCKED("%s task is blocked by another running task"),
        NO_TASK_RUNNING("There are no running tasks");

        private final String message;

        private Result(String message) {
            this.message = message;
        }

        private Component getMessage(Task task, CommandSender sender) {
            if (STARTED.equals((Object)this)) {
                return this.getTaskStartedMessage(task, sender);
            }
            if (COMPLETED.equals((Object)this)) {
                return this.getTaskCompletedMessage(task, sender);
            }
            return Component.text((String)this.message.formatted(task.getTaskName()));
        }

        public Result sendMessage(Task task, CommandSender sender) {
            Backuper.getInstance().getLogManager().log(this.getMessage(task, sender), sender);
            return this;
        }

        private Component getTaskCompletedMessage(Task task, CommandSender sender) {
            TextComponent message = Component.empty();
            message = message.append((Component)Component.text((String)"The ")).append(((TextComponent)Component.text((String)task.getTaskName()).decorate(TextDecoration.BOLD)).color(TextColor.color((int)(task.isCancelled() ? 11542784 : 300875)))).append((Component)Component.text((String)" task %s".formatted(task.isCancelled() ? "cancelled" : "completed")));
            if (!(sender instanceof ConsoleCommandSender)) {
                return UIUtils.getFramedMessage((Component)message, 15, sender);
            }
            return UIUtils.getFramedMessage((Component)message, sender);
        }

        private Component getTaskStartedMessage(Task task, CommandSender sender) {
            TextComponent header = Component.empty();
            TextComponent message = Component.empty();
            if (!(sender instanceof ConsoleCommandSender)) {
                header = header.append((Component)Component.text((String)"The ")).append(((TextComponent)Component.text((String)task.getTaskName()).decorate(TextDecoration.BOLD)).color(TextColor.color((int)300875))).append((Component)Component.text((String)" task has been started"));
                message = message.append(((TextComponent)((TextComponent)Component.text((String)"[STATUS]").clickEvent(ClickEvent.runCommand((String)"/backuper task status"))).color(TextColor.color((int)17, (int)102, (int)212))).decorate(TextDecoration.BOLD)).append((Component)Component.space()).append(((TextComponent)((TextComponent)Component.text((String)"[CANCEL]").decorate(TextDecoration.BOLD)).color(TextColor.color((int)11542784))).clickEvent(ClickEvent.runCommand((String)"/backuper task cancel")));
            } else {
                header = header.append((Component)Component.text((String)"The ")).append(((TextComponent)Component.text((String)task.getTaskName()).decorate(TextDecoration.BOLD)).color(TextColor.color((int)300875))).append((Component)Component.text((String)" task has been started"));
                message = message.append((Component)Component.text((String)"You can check the task status using command")).append((Component)Component.newline()).append(((TextComponent)Component.text((String)"/backuper task status").decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.suggestCommand((String)"/backuper task status"))).append((Component)Component.newline()).append((Component)Component.text((String)"You can cancel the task using command")).append((Component)Component.newline()).append(((TextComponent)Component.text((String)"/backuper task cancel").decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.suggestCommand((String)"/backuper task cancel")));
            }
            if (!(sender instanceof ConsoleCommandSender)) {
                return UIUtils.getFramedMessage((Component)header, (Component)message, 15, sender);
            }
            return UIUtils.getFramedMessage((Component)header, (Component)message, sender);
        }
    }
}

