/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.util;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import ru.dvdishka.backuper.Backuper;

public class UIUtils {
    public static void returnFailure(String message, CommandSender sender) {
        Component text = Component.text((String)message).color((TextColor)NamedTextColor.RED);
        UIUtils.sendMessage(text, sender);
    }

    public static void returnSuccess(String message, CommandSender sender) {
        Component text = Component.text((String)message).color((TextColor)NamedTextColor.GREEN);
        UIUtils.sendMessage(text, sender);
    }

    public static void returnWarning(String message, CommandSender sender) {
        Component text = Component.text((String)message).color((TextColor)NamedTextColor.YELLOW);
        UIUtils.sendMessage(text, sender);
    }

    public static void sendMessage(String message, CommandSender sender) {
        UIUtils.sendMessage((Component)Component.text((String)message), sender);
    }

    public static void sendMessage(Component message, CommandSender sender) {
        try {
            if (sender instanceof ConsoleCommandSender) {
                Backuper.getInstance().getLogManager().log(message, sender);
            } else {
                sender.sendMessage(message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cancelSound(CommandSender sender) {
        try {
            Class.forName("net.kyori.adventure.sound.Sound").getMethod("sound", new Class[0]);
            sender.playSound((Sound)Sound.sound((Sound)Sound.sound((Key)Key.key((String)"block.anvil.place"), (Sound.Source)Sound.Source.MASTER, (float)50.0f, (float)1.0f)).build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void buttonSound(CommandSender sender) {
        try {
            Class.forName("net.kyori.adventure.sound.Sound").getMethod("sound", new Class[0]);
            sender.playSound((Sound)Sound.sound((Sound)Sound.sound((Key)Key.key((String)"ui.button.click"), (Sound.Source)Sound.Source.MASTER, (float)50.0f, (float)1.0f)).build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void successSound(CommandSender sender) {
        try {
            Class.forName("net.kyori.adventure.sound.Sound").getMethod("sound", new Class[0]);
            sender.playSound((Sound)Sound.sound((Sound)Sound.sound((Key)Key.key((String)"entity.player.levelup"), (Sound.Source)Sound.Source.MASTER, (float)50.0f, (float)1.0f)).build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void notificationSound(CommandSender sender) {
        try {
            Class.forName("net.kyori.adventure.sound.Sound").getMethod("sound", new Class[0]);
            sender.playSound((Sound)Sound.sound((Sound)Sound.sound((Key)Key.key((String)"entity.player.levelup"), (Sound.Source)Sound.Source.MASTER, (float)50.0f, (float)50.0f)).build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Component getFramedMessage(Component header, Component message, CommandSender sender) {
        return UIUtils.getFramedMessage(header, message, 42, sender);
    }

    public static Component getFramedMessage(Component header, Component message, int dashNumber, CommandSender sender) {
        TextComponent framedMessage = Component.empty();
        if (sender instanceof ConsoleCommandSender) {
            framedMessage = framedMessage.append((Component)Component.newline());
        }
        framedMessage = framedMessage.append(((TextComponent)Component.text((String)"-".repeat(dashNumber)).decorate(TextDecoration.BOLD)).color(UIUtils.getMainColor())).append((Component)Component.newline());
        framedMessage = framedMessage.append(header).append((Component)Component.newline());
        framedMessage = framedMessage.append(((TextComponent)Component.text((String)"-".repeat(dashNumber)).decorate(TextDecoration.BOLD)).color(UIUtils.getSecondaryColor())).append((Component)Component.newline());
        framedMessage = framedMessage.append(message);
        framedMessage = framedMessage.append((Component)Component.newline()).append(((TextComponent)Component.text((String)"-".repeat(dashNumber)).decorate(TextDecoration.BOLD)).color(UIUtils.getMainColor()));
        return framedMessage;
    }

    public static Component getFramedMessage(Component message, int dashNumber, CommandSender sender) {
        TextComponent framedMessage = Component.empty();
        if (sender instanceof ConsoleCommandSender) {
            framedMessage = framedMessage.append((Component)Component.newline());
        }
        framedMessage = framedMessage.append(((TextComponent)Component.text((String)"-".repeat(dashNumber)).decorate(TextDecoration.BOLD)).color(UIUtils.getMainColor())).append((Component)Component.newline());
        framedMessage = framedMessage.append(message);
        framedMessage = framedMessage.append((Component)Component.newline()).append(((TextComponent)Component.text((String)"-".repeat(dashNumber)).decorate(TextDecoration.BOLD)).color(UIUtils.getMainColor()));
        return framedMessage;
    }

    public static Component getFramedMessage(Component message, CommandSender sender) {
        return UIUtils.getFramedMessage(message, 42, sender);
    }

    public static void sendFramedMessage(Component header, Component message, CommandSender sender) {
        UIUtils.sendFramedMessage(header, message, 42, sender);
    }

    public static void sendFramedMessage(Component header, Component message, int dashNumber, CommandSender sender) {
        UIUtils.sendMessage(UIUtils.getFramedMessage(header, message, dashNumber, sender), sender);
    }

    public static void sendFramedMessage(Component message, int dashNumber, CommandSender sender) {
        UIUtils.sendMessage(UIUtils.getFramedMessage(message, dashNumber, sender), sender);
    }

    public static void sendFramedMessage(Component message, CommandSender sender) {
        UIUtils.sendFramedMessage(message, 42, sender);
    }

    public static TextColor getMainColor() {
        return TextColor.color((int)5574007);
    }

    public static TextColor getSecondaryColor() {
        return TextColor.color((int)8589330);
    }
}

