/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.backend.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.storage.LocalStorage;

public class Utils {
    public static final Properties properties = new Properties();
    public static boolean errorSetWritable = false;
    public static volatile HashMap<String, Boolean> isAutoSaveEnabled = new HashMap();
    public static final List<String> downloadLinks;
    public static final List<String> downloadLinksName;
    public static URL getLatestVersionURL;
    public static final boolean isWindows;
    public static boolean isFolia;

    public static String getProperty(String property) {
        return properties.getProperty(property);
    }

    public static long getFileFolderByteSize(File path) {
        if (!path.exists()) {
            return 0L;
        }
        if (!path.isDirectory()) {
            try {
                return Files.size(path.toPath());
            }
            catch (Exception e) {
                Backuper.getInstance().getLogManager().warn("Something went wrong while trying to calculate file size!");
                Backuper.getInstance().getLogManager().warn(e);
                return 0L;
            }
        }
        long size = 0L;
        if (path.isDirectory()) {
            for (File file : Objects.requireNonNull(path.listFiles())) {
                size += Utils.getFileFolderByteSize(file);
            }
        }
        return size;
    }

    public static long getFileFolderByteSizeExceptExcluded(File path) {
        if (!path.exists() || Utils.isExcludedDirectory(path, null)) {
            return 0L;
        }
        if (!path.isDirectory()) {
            try {
                return Files.size(path.toPath());
            }
            catch (Exception e) {
                Backuper.getInstance().getLogManager().warn("Something went wrong while trying to calculate backup size!");
                Backuper.getInstance().getLogManager().warn(e);
                return 0L;
            }
        }
        long size = 0L;
        if (path.isDirectory()) {
            for (File file : Objects.requireNonNull(path.listFiles())) {
                size += Utils.getFileFolderByteSizeExceptExcluded(file);
            }
        }
        return size;
    }

    public static boolean isExcludedDirectory(File path, CommandSender sender) {
        boolean isExcludedDirectory;
        block10: {
            if (!path.exists()) {
                return true;
            }
            isExcludedDirectory = false;
            try {
                Path normalizedPath = path.toPath().toAbsolutePath().normalize();
                List<LocalStorage> localStorages = Backuper.getInstance().getStorageManager().getStorages().stream().filter(storage -> storage instanceof LocalStorage).map(storage -> (LocalStorage)storage).toList();
                List<Path> normalizedBackupFolderPaths = localStorages.stream().map(storage -> new File(storage.getConfig().getBackupsFolder()).toPath().toAbsolutePath().normalize()).toList();
                if (!localStorages.stream().anyMatch(storage -> path.toPath().startsWith(new File(storage.getConfig().getBackupsFolder()).toPath()))) {
                    if (!normalizedBackupFolderPaths.stream().anyMatch(normalizedPath::startsWith) && !localStorages.stream().anyMatch(storage -> !isWindows && path.toPath().startsWith(new File("./%s".formatted(storage.getConfig().getBackupsFolder())).toPath())) && !localStorages.stream().anyMatch(storage -> isWindows && path.toPath().startsWith(new File(storage.getConfig().getBackupsFolder()).toPath())) && !localStorages.stream().anyMatch(storage -> isWindows && storage.getConfig().getBackupsFolder().charAt(1) != ':' && path.toPath().startsWith(new File(".\\%s".formatted(storage.getConfig().getBackupsFolder())).toPath()))) break block10;
                }
                return true;
            }
            catch (SecurityException e) {
                Backuper.getInstance().getLogManager().warn("Failed to copy file \"%s\", no access".formatted(path.getAbsolutePath()), sender);
                Backuper.getInstance().getLogManager().warn(e);
            }
            catch (Exception e) {
                Backuper.getInstance().getLogManager().warn("Something went wrong while trying to copy file \"%s\"".formatted(path.getAbsolutePath()), sender);
                Backuper.getInstance().getLogManager().warn(e);
            }
        }
        for (String excludeDirectoryFromBackup : Backuper.getInstance().getConfigManager().getBackupConfig().getExcludeDirectoryFromBackup()) {
            try {
                File excludeDirectoryFromBackupFile = Paths.get(excludeDirectoryFromBackup, new String[0]).toFile().getCanonicalFile();
                if (!path.getCanonicalFile().toPath().startsWith(excludeDirectoryFromBackupFile.toPath())) continue;
                isExcludedDirectory = true;
            }
            catch (SecurityException e) {
                Backuper.getInstance().getLogManager().warn("Failed to copy file \"%s\", no access".formatted(path.getAbsolutePath()), sender);
                Backuper.getInstance().getLogManager().warn(e);
                return true;
            }
            catch (Exception e) {
                Backuper.getInstance().getLogManager().warn("Something went wrong while trying to copy file \"%s\"".formatted(path.getAbsolutePath()), sender);
                Backuper.getInstance().getLogManager().warn(e);
                return true;
            }
        }
        return isExcludedDirectory;
    }

    static {
        try {
            properties.load(Utils.class.getClassLoader().getResourceAsStream("project.properties"));
        }
        catch (Exception e) {
            Backuper.getInstance().getLogManager().devWarn("Failed to load properties!");
            Backuper.getInstance().getLogManager().warn(e);
        }
        downloadLinks = List.of("https://modrinth.com/plugin/backuper/versions#all-versions", "https://hangar.papermc.io/Collagen/Backuper");
        downloadLinksName = List.of("Modrinth", "Hangar");
        getLatestVersionURL = null;
        try {
            getLatestVersionURL = URI.create("https://hangar.papermc.io/api/v1/projects/Collagen/Backuper/latestrelease").toURL();
        }
        catch (MalformedURLException e) {
            Backuper.getInstance().getLogManager().warn("Failed to check Backuper updates!");
            Backuper.getInstance().getLogManager().warn(e);
        }
        isWindows = System.getProperty("os.name").toLowerCase().contains("win");
        isFolia = false;
    }
}

