/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.storage.UserAuthStorage;
import ru.dvdishka.backuper.handlers.commands.Permission;
import ru.dvdishka.backuper.handlers.commands.backup.BackupCommand;
import ru.dvdishka.backuper.handlers.commands.googleDrive.AccountLinkCommand;
import ru.dvdishka.backuper.handlers.commands.list.ListCommand;
import ru.dvdishka.backuper.handlers.commands.menu.CopyToCommand;
import ru.dvdishka.backuper.handlers.commands.menu.DeleteCommand;
import ru.dvdishka.backuper.handlers.commands.menu.MenuCommand;
import ru.dvdishka.backuper.handlers.commands.menu.ToZIPCommand;
import ru.dvdishka.backuper.handlers.commands.menu.UnZIPCommand;
import ru.dvdishka.backuper.handlers.commands.reload.ReloadCommand;
import ru.dvdishka.backuper.handlers.commands.task.CancelCommand;
import ru.dvdishka.backuper.handlers.commands.task.StatusCommand;
import ru.dvdishka.shade.commandapi.AbstractArgumentTree;
import ru.dvdishka.shade.commandapi.CommandTree;
import ru.dvdishka.shade.commandapi.arguments.Argument;
import ru.dvdishka.shade.commandapi.arguments.ArgumentSuggestions;
import ru.dvdishka.shade.commandapi.arguments.IntegerArgument;
import ru.dvdishka.shade.commandapi.arguments.LiteralArgument;
import ru.dvdishka.shade.commandapi.arguments.LongArgument;
import ru.dvdishka.shade.commandapi.arguments.StringArgument;
import ru.dvdishka.shade.commandapi.arguments.TextArgument;
import ru.dvdishka.shade.commandapi.executors.ExecutorType;

public class CommandManager {
    public void registerCommands() {
        CommandTree backupCommandTree = (CommandTree)new CommandTree("backuper").withPermission(Permission.BACKUPER.getPermission());
        backupCommandTree.then(new LiteralArgument("backup").then(((Argument)((Argument)((Argument)((Argument)new StringArgument("storage").includeSuggestions(this.getMultiStorageSuggestion())).executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new BackupCommand(sender, args, "NOTHING").execute()), new ExecutorType[0])).then((AbstractArgumentTree)new LongArgument("delaySeconds").executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new BackupCommand(sender, args, "NOTHING").execute()), new ExecutorType[0]))).then(((Argument)((Argument)new LiteralArgument("stop").withPermission(Permission.STOP.getPermission())).executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new BackupCommand(sender, args, "STOP").execute()), new ExecutorType[0])).then((AbstractArgumentTree)new LongArgument("delaySeconds").executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new BackupCommand(sender, args, "STOP").execute()), new ExecutorType[0])))).then(((Argument)((Argument)new LiteralArgument("restart").withPermission(Permission.RESTART.getPermission())).executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new BackupCommand(sender, args, "RESTART").execute()), new ExecutorType[0])).then((AbstractArgumentTree)new LongArgument("delaySeconds").executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new BackupCommand(sender, args, "RESTART").execute()), new ExecutorType[0])))));
        backupCommandTree.register();
        CommandTree backupListCommandTree = (CommandTree)new CommandTree("backuper").withPermission(Permission.BACKUPER.getPermission());
        backupListCommandTree.then(new LiteralArgument("list").then(((Argument)((Argument)new StringArgument("storage").includeSuggestions(this.getSingleStorageSuggestion())).executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new ListCommand(true, sender, args).execute()), new ExecutorType[0])).then((AbstractArgumentTree)new IntegerArgument("pageNumber").executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new ListCommand(true, sender, args).execute()), new ExecutorType[0]))));
        backupListCommandTree.register();
        CommandTree backupReloadCommandTree = (CommandTree)new CommandTree("backuper").withPermission(Permission.BACKUPER.getPermission());
        backupReloadCommandTree.then((AbstractArgumentTree)((Argument)new LiteralArgument("reload").withPermission(Permission.CONFIG_RELOAD.getPermission())).executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new ReloadCommand(sender, args).execute()), new ExecutorType[0]));
        backupReloadCommandTree.register();
        CommandTree backupMenuCommandTree = (CommandTree)new CommandTree("backuper").withPermission(Permission.BACKUPER.getPermission());
        backupMenuCommandTree.then(new LiteralArgument("menu").then(((Argument)new StringArgument("storage").includeSuggestions(this.getSingleStorageSuggestion())).then(((Argument)((Argument)((Argument)((Argument)((Argument)new TextArgument("backupName").includeSuggestions(ArgumentSuggestions.stringCollectionAsync(info -> CompletableFuture.supplyAsync(() -> {
            Storage storage = Backuper.getInstance().getStorageManager().getStorage((String)info.previousArgs().get("storage"));
            if (storage == null || !((CommandSender)info.sender()).hasPermission(Permission.STORAGE.getPermission(storage))) {
                return new ArrayList();
            }
            return storage.getBackupManager().getBackupList().stream().sorted(Backup::compareTo).map(backup -> "\"%s\"".formatted(backup.getName())).toList();
        })))).executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new MenuCommand(sender, args).execute()), new ExecutorType[0])).then(new LiteralArgument("copyto").then((AbstractArgumentTree)((Argument)new StringArgument("targetStorage").includeSuggestions(ArgumentSuggestions.stringCollectionAsync(suggestionInfo -> CompletableFuture.supplyAsync(() -> Backuper.getInstance().getStorageManager().getStorages().stream().filter(storage -> ((CommandSender)suggestionInfo.sender()).hasPermission(Permission.STORAGE.getPermission((Storage)storage))).map(Storage::getId).filter(id -> !id.equals(suggestionInfo.previousArgs().get("storage"))).toList())))).executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new CopyToCommand(sender, args).execute()), new ExecutorType[0])))).then((AbstractArgumentTree)new LiteralArgument("delete").executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new DeleteCommand(sender, args).execute()), new ExecutorType[0]))).then((AbstractArgumentTree)new LiteralArgument("unzip").executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new UnZIPCommand(sender, args).execute()), new ExecutorType[0]))).then((AbstractArgumentTree)new LiteralArgument("tozip").executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new ToZIPCommand(sender, args).execute()), new ExecutorType[0])))));
        backupMenuCommandTree.register();
        CommandTree backupTaskCommandTree = (CommandTree)new CommandTree("backuper").withPermission(Permission.BACKUPER.getPermission());
        backupTaskCommandTree.then(((Argument)new LiteralArgument("task").then((AbstractArgumentTree)new LiteralArgument("cancel").executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new CancelCommand(sender, args).execute()), new ExecutorType[0]))).then((AbstractArgumentTree)((Argument)new LiteralArgument("status").withPermission(Permission.STATUS.getPermission())).executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new StatusCommand(sender, args).execute()), new ExecutorType[0])));
        backupTaskCommandTree.register();
        CommandTree backupAccountCommandTree = (CommandTree)new CommandTree("backuper").withPermission(Permission.BACKUPER.getPermission());
        backupAccountCommandTree.then(new LiteralArgument("account").then(((Argument)new StringArgument("storage").includeSuggestions(ArgumentSuggestions.stringCollectionAsync(info -> CompletableFuture.supplyAsync(() -> Backuper.getInstance().getStorageManager().getStorages().stream().filter(storage -> ((CommandSender)info.sender()).hasPermission(Permission.ACCOUNT.getPermission((Storage)storage))).filter(storage -> storage instanceof UserAuthStorage).map(Storage::getId).toList())))).then((AbstractArgumentTree)new LiteralArgument("link").executes((sender, args) -> Backuper.getInstance().getScheduleManager().runAsync(() -> new AccountLinkCommand(sender, args).execute()), new ExecutorType[0]))));
        backupAccountCommandTree.register();
    }

    private ArgumentSuggestions<CommandSender> getSingleStorageSuggestion() {
        return ArgumentSuggestions.stringCollectionAsync(suggestionInfo -> CompletableFuture.supplyAsync(() -> Backuper.getInstance().getStorageManager().getStorages().stream().filter(storage -> ((CommandSender)suggestionInfo.sender()).hasPermission(Permission.STORAGE.getPermission((Storage)storage))).map(Storage::getId).toList()));
    }

    private ArgumentSuggestions<CommandSender> getMultiStorageSuggestion() {
        return ArgumentSuggestions.stringCollectionAsync(suggestionInfo -> CompletableFuture.supplyAsync(() -> Backuper.getInstance().getStorageManager().getStorages().stream().filter(storage -> ((CommandSender)suggestionInfo.sender()).hasPermission(Permission.BACKUP.getPermission((Storage)storage))).filter(storage -> {
            String lastStorageString = suggestionInfo.currentArg().substring(!suggestionInfo.currentArg().contains("-") ? 0 : suggestionInfo.currentArg().lastIndexOf("-") + 1);
            if (Backuper.getInstance().getStorageManager().getStorage(lastStorageString) != null) {
                return true;
            }
            return storage.getId().startsWith(lastStorageString);
        }).filter(storage -> Arrays.stream(suggestionInfo.currentArg().split("-")).noneMatch(currentArgumentStorage -> currentArgumentStorage.equals(storage.getId()))).map(Storage::getId).map(id -> {
            Object currentArg = suggestionInfo.currentArg();
            String lastStorageString = suggestionInfo.currentArg().substring(!suggestionInfo.currentArg().contains("-") ? 0 : suggestionInfo.currentArg().lastIndexOf("-") + 1);
            if (Backuper.getInstance().getStorageManager().getStorage(lastStorageString) != null) {
                currentArg = (String)currentArg + "-";
            }
            int lastIndex = ((String)currentArg).lastIndexOf("-") == -1 ? 0 : ((String)currentArg).lastIndexOf("-") + 1;
            return "%s%s".formatted(((String)currentArg).substring(0, lastIndex), id);
        }).toList()));
    }
}

