/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.backuper.handlers.commands.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.SequencedCollection;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import ru.dvdishka.backuper.Backuper;
import ru.dvdishka.backuper.backend.backup.Backup;
import ru.dvdishka.backuper.backend.storage.Storage;
import ru.dvdishka.backuper.backend.util.UIUtils;
import ru.dvdishka.backuper.handlers.commands.Command;
import ru.dvdishka.backuper.handlers.commands.Permission;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class ListCommand
extends Command {
    private List<List<TextComponent>> pages;
    private Storage storage;
    private final boolean sendResult;
    private final HashMap<String, Long> backupNameMbSize = new HashMap();
    private final HashMap<String, Backup.BackupFileType> backupNameFileType = new HashMap();

    public ListCommand(boolean sendResult, CommandSender sender, CommandArguments arguments) {
        super(sender, arguments);
        this.sendResult = sendResult;
    }

    @Override
    public boolean check() {
        this.storage = Backuper.getInstance().getStorageManager().getStorage((String)this.arguments.get("storage"));
        if (this.storage == null) {
            this.returnFailure("Wrong storage name %s".formatted((String)this.arguments.get("storage")));
            return false;
        }
        this.sendMessage("Creating a list of backups may take some time...");
        if (!this.storage.checkConnection()) {
            this.returnFailure("Failed to establish connection to %s storage".formatted(this.storage.getId()));
            return false;
        }
        if (!this.sender.hasPermission(Permission.STORAGE.getPermission(this.storage))) {
            this.returnFailure("Don't have enough permissions to perform this command");
            return false;
        }
        int listPageCount = this.getListPageCount();
        int pageNumber = (Integer)this.arguments.getOrDefault("pageNumber", (Object)1);
        if (pageNumber < 1) {
            this.returnFailure("Invalid page number!");
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        TextComponent header = Component.empty();
        header = header.append(Component.text((String)"Backup list").decorate(TextDecoration.BOLD)).append((Component)Component.space()).append(((TextComponent)Component.text((String)"(%s)".formatted(this.storage.getId())).color(UIUtils.getSecondaryColor())).decorate(TextDecoration.BOLD));
        int pageNumber = (Integer)this.arguments.getOrDefault("pageNumber", (Object)1);
        if (!(this.sender instanceof ConsoleCommandSender)) {
            this.sendFramedMessage((Component)header, this.createListMessage(pageNumber, true), 15);
        } else {
            this.sendFramedMessage((Component)header, this.createListMessage(pageNumber, this.arguments.get("pageNumber") != null), 41);
        }
        this.buttonSound();
    }

    private void updateListPages() {
        SequencedCollection<Backup> backups = new ArrayList<Backup>(this.storage.getBackupManager().getBackupList());
        backups.sort(Backup::compareTo);
        backups = backups.reversed();
        ArrayList<List<TextComponent>> pages = new ArrayList<List<TextComponent>>();
        for (int i = 1; i <= backups.size(); ++i) {
            if (i % 10 == 1) {
                pages.add(new ArrayList());
            }
            Backup backup = (Backup)backups.get(i - 1);
            String backupName = backup.getName();
            String backupFormattedName = backup.getFormattedName();
            long backupMbSize = backup.getMbSize();
            this.backupNameMbSize.put(backupFormattedName, backupMbSize);
            this.backupNameFileType.put(backupFormattedName, backup.getFileType());
            HoverEvent hoverEvent = HoverEvent.showText((Component)Component.text((String)"(%s) %s %s MB".formatted(backup.getStorage().getId(), backup.getFileType().name(), backupMbSize)));
            ClickEvent clickEvent = ClickEvent.runCommand((String)"/backuper menu %s \"%s\"".formatted(this.storage.getId(), backupName));
            ((List)pages.get((i - 1) / 10)).add((TextComponent)((TextComponent)Component.text((String)backupFormattedName).hoverEvent((HoverEventSource)hoverEvent)).clickEvent(clickEvent));
        }
        this.pages = pages;
    }

    private Component createListMessage(int pageNumber, boolean pagedListMessage) {
        TextComponent message = Component.empty();
        if (!(this.sender instanceof ConsoleCommandSender)) {
            message = message.append(((TextComponent)((TextComponent)Component.text((String)"<<<<<<<<").decorate(TextDecoration.BOLD)).color(UIUtils.getSecondaryColor())).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)"/backuper list %s %s".formatted(this.storage.getId(), pageNumber - 1)))).append(Component.text((String)String.valueOf(pageNumber)).decorate(TextDecoration.BOLD)).append(((TextComponent)((TextComponent)Component.text((String)">>>>>>>>").decorate(TextDecoration.BOLD)).color(UIUtils.getSecondaryColor())).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)"/backuper list %s %s".formatted(this.storage.getId(), pageNumber + 1)))).append((Component)Component.newline());
            if (this.pages.size() >= pageNumber) {
                for (TextComponent backupComponent : this.pages.get(pageNumber - 1)) {
                    message = message.append((Component)Component.space()).append((Component)backupComponent).append((Component)Component.newline());
                }
            }
            message = message.append(((TextComponent)((TextComponent)Component.text((String)"<<<<<<<<").decorate(TextDecoration.BOLD)).color(UIUtils.getSecondaryColor())).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)"/backuper list %s %s".formatted(this.storage.getId(), pageNumber - 1)))).append(Component.text((String)String.valueOf(pageNumber)).decorate(TextDecoration.BOLD)).append(((TextComponent)((TextComponent)Component.text((String)">>>>>>>>").decorate(TextDecoration.BOLD)).color(UIUtils.getSecondaryColor())).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)"/backuper list %s %s".formatted(this.storage.getId(), pageNumber + 1))));
        } else {
            int backupIndex = 1;
            if (pagedListMessage) {
                message = message.append(((TextComponent)Component.text((String)"<".repeat(20)).decorate(TextDecoration.BOLD)).color(UIUtils.getSecondaryColor())).append((Component)Component.text((int)pageNumber)).append(((TextComponent)Component.text((String)">".repeat(20)).decorate(TextDecoration.BOLD)).color(UIUtils.getSecondaryColor())).append((Component)Component.newline());
                if (this.pages.size() >= pageNumber) {
                    for (TextComponent backupComponent : this.pages.get(pageNumber - 1)) {
                        if (backupIndex > 1) {
                            message = message.append((Component)Component.newline());
                        }
                        String backupName = backupComponent.content();
                        message = message.append((Component)Component.text((String)backupName)).append((Component)Component.space()).append((Component)Component.text((String)"(%s)".formatted(this.storage.getId()))).append((Component)Component.space()).append((Component)Component.text((String)this.backupNameFileType.get(backupName).name())).append((Component)Component.space()).append((Component)Component.text((long)this.backupNameMbSize.get(backupName))).append((Component)Component.space()).append((Component)Component.text((String)"MB"));
                        ++backupIndex;
                    }
                }
                message = message.append((Component)Component.newline()).append(((TextComponent)Component.text((String)"<".repeat(20)).decorate(TextDecoration.BOLD)).color(UIUtils.getSecondaryColor())).append((Component)Component.text((int)pageNumber)).append(((TextComponent)Component.text((String)">".repeat(20)).decorate(TextDecoration.BOLD)).color(UIUtils.getSecondaryColor()));
            } else {
                for (List<TextComponent> page : this.pages) {
                    for (TextComponent backupComponent : page) {
                        if (backupIndex > 1) {
                            message = message.append((Component)Component.newline());
                        }
                        String backupName = backupComponent.content();
                        message = message.append((Component)Component.text((String)backupComponent.content())).append((Component)Component.space()).append((Component)Component.text((String)"(%s)".formatted(this.storage.getId()))).append((Component)Component.space()).append((Component)Component.text((String)this.backupNameFileType.get(backupName).name())).append((Component)Component.space()).append((Component)Component.text((long)this.backupNameMbSize.get(backupName))).append((Component)Component.space()).append((Component)Component.text((String)"MB"));
                        ++backupIndex;
                    }
                }
            }
        }
        return message;
    }

    private int getListPageCount() {
        this.updateListPages();
        return this.pages.size();
    }

    @Override
    protected void returnFailure(String message) {
        if (this.sendResult) {
            super.returnFailure(message);
        }
    }

    @Override
    protected void returnSuccess(String message) {
        if (this.sendResult) {
            super.returnSuccess(message);
        }
    }

    @Override
    protected void returnWarning(String message) {
        if (this.sendResult) {
            super.returnWarning(message);
        }
    }

    @Override
    protected void sendMessage(String message) {
        if (this.sendResult) {
            super.sendMessage(message);
        }
    }

    @Override
    protected void sendFramedMessage(Component message) {
        if (this.sendResult) {
            super.sendFramedMessage(message);
        }
    }

    @Override
    protected void sendFramedMessage(Component message, int dashNumber) {
        if (this.sendResult) {
            super.sendFramedMessage(message, dashNumber);
        }
    }

    @Override
    protected void sendFramedMessage(Component header, Component message) {
        if (this.sendResult) {
            super.sendFramedMessage(header, message);
        }
    }

    @Override
    protected void sendFramedMessage(Component header, Component message, int dashNumber) {
        if (this.sendResult) {
            super.sendFramedMessage(header, message, dashNumber);
        }
    }
}

