/*
 * Decompiled with CFR 0.152.
 */
package ru.dvdishka.shade.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import ru.dvdishka.shade.commandapi.arguments.CommandAPIArgumentType;
import ru.dvdishka.shade.commandapi.arguments.SafeOverrideableArgument;
import ru.dvdishka.shade.commandapi.exceptions.InvalidRangeException;
import ru.dvdishka.shade.commandapi.executors.CommandArguments;

public class DoubleArgument
extends SafeOverrideableArgument<Double, Double> {
    public DoubleArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)DoubleArgumentType.doubleArg(), String::valueOf);
    }

    public DoubleArgument(String nodeName, double min2) {
        super(nodeName, (ArgumentType<?>)DoubleArgumentType.doubleArg((double)min2), String::valueOf);
    }

    public DoubleArgument(String nodeName, double min2, double max) {
        super(nodeName, (ArgumentType<?>)DoubleArgumentType.doubleArg((double)min2, (double)max), String::valueOf);
        if (max < min2) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Double> getPrimitiveType() {
        return Double.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_DOUBLE;
    }

    @Override
    public <Source> Double parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return (Double)cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

