/*
 * Decompiled with CFR 0.152.
 */
package gg.jos.shieldbreaksound.events;

import gg.jos.shieldbreaksound.ShieldBreakSound;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class ShieldBreakEvent
implements Listener {
    private final ShieldBreakSound shieldBreakSound;
    private final FileConfiguration config;
    private final Set<Material> axeMaterials;

    public ShieldBreakEvent(ShieldBreakSound shieldBreakSound, FileConfiguration config) {
        this.shieldBreakSound = shieldBreakSound;
        this.config = config;
        this.axeMaterials = this.loadAxeMaterials(config);
    }

    @EventHandler
    public void onAxeDisableShield(EntityDamageByEntityEvent event) {
        Sound sound;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player victim = (Player)event.getEntity();
        Player attacker = (Player)event.getDamager();
        if (!this.isAxe(attacker.getInventory().getItemInMainHand().getType())) {
            return;
        }
        if (!victim.isBlocking()) {
            return;
        }
        String soundName = this.config.getString("noise", "ENTITY_SHIELD_BREAK");
        try {
            sound = Sound.valueOf((String)soundName);
        }
        catch (IllegalArgumentException e) {
            sound = Sound.ITEM_SHIELD_BREAK;
        }
        double volume = this.config.getDouble("volume", 1.0);
        double pitch = this.config.getDouble("pitch", 1.0);
        victim.playSound(victim.getLocation(), sound, (float)volume, (float)pitch);
        attacker.playSound(attacker.getLocation(), sound, (float)volume, (float)pitch);
    }

    private boolean isAxe(Material material) {
        return this.axeMaterials.contains(material);
    }

    private Set<Material> loadAxeMaterials(FileConfiguration config) {
        HashSet<Material> axes = new HashSet<Material>();
        List axeList = config.getStringList("axes");
        for (String axeName : axeList) {
            try {
                axes.add(Material.valueOf((String)axeName));
            }
            catch (IllegalArgumentException e) {
                this.shieldBreakSound.getLogger().warning("Invalid axe name: " + axeName);
            }
        }
        return axes;
    }
}

