/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.playertracking_common_forge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.collective_common_forge.functions.PlayerFunctions;
import com.natamus.playertracking_common_forge.util.Tracking;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CommandTrack {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"track").requires(iCommandSender -> iCommandSender.getEntity() instanceof Player)).then(Commands.literal((String)"help").executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).getPlayerOrException();
            MessageFunctions.sendMessage((Player)player, (String)"Tracking Help Page (1/5)", (ChatFormatting)ChatFormatting.DARK_GRAY, (boolean)true);
            MessageFunctions.sendMessage((Player)player, (String)"For an introduction to tracking read page 2.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"For information on building a tracker read page 3.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"For explanation on '/track all' read page 4.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"For explanation on '/track [playerName]' read page 5.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"To select a page: '/track help [page]'", (ChatFormatting)ChatFormatting.GRAY);
            return 1;
        }))).then(Commands.literal((String)"help").then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).getPlayerOrException();
            int page = IntegerArgumentType.getInteger((CommandContext)command, (String)"page");
            if (page == 2) {
                MessageFunctions.sendMessage((Player)player, (String)"Tracking Help Page (2/5) - Introduction", (ChatFormatting)ChatFormatting.DARK_GRAY, (boolean)true);
                MessageFunctions.sendMessage((Player)player, (String)"Tracking is a feature to encourage raiding on a server. Without this it would be near-impossible to find enemy bases legit, and would give hackers an unfair advantage. Tracking is the art of finding a player before he or she finds you. It is not cheap, you will need many valuable materials to start off. Read the next few pages for more information.", (ChatFormatting)ChatFormatting.GRAY);
                return 1;
            }
            if (page == 3) {
                MessageFunctions.sendMessage((Player)player, (String)"Tracking Help Page (3/5) - Building", (ChatFormatting)ChatFormatting.DARK_GRAY, (boolean)true);
                MessageFunctions.sendMessage((Player)player, (String)"To start building a solid tracker you will need a 'Diamond Block' for the middle, 4 'Gold Blocks' for the end of each 'arm', and as much 'Obsidian' as you can find for the length of the arms. Every obsidian block equals 25 blocks in the real world. Build your tracker at a smart position. Not too close to spawn, and not at coords that are easy to guess. You are not the only one that will try to make one.", (ChatFormatting)ChatFormatting.GRAY);
                MessageFunctions.sendMessage((Player)player, (String)"To see a 'layout' of a tracker do '/track help 3 layout'", (ChatFormatting)ChatFormatting.DARK_GRAY);
                return 1;
            }
            if (page == 4) {
                MessageFunctions.sendMessage((Player)player, (String)"Tracking Help Page (4/5) - /track all", (ChatFormatting)ChatFormatting.DARK_GRAY, (boolean)true);
                MessageFunctions.sendMessage((Player)player, (String)"Once you have made your own solid tracker, it's time to find those bases! Stand on the Diamond block in the middle of your tracker and do /track all. If there are players within the range of your tracker they will show up. You will need a player on atleast 2 of your arms to continue to page 5. If not, try to increase the length of your arms or wait until there are more/different players online.", (ChatFormatting)ChatFormatting.GRAY);
                MessageFunctions.sendMessage((Player)player, (String)"To proceed to page 5 do '/track help 5'", (ChatFormatting)ChatFormatting.DARK_GRAY);
                return 1;
            }
            if (page == 5) {
                MessageFunctions.sendMessage((Player)player, (String)"Tracking Help Page (5/5) - /track [playerName]", (ChatFormatting)ChatFormatting.DARK_GRAY, (boolean)true);
                MessageFunctions.sendMessage((Player)player, (String)"If you are lucky enough to find a player on 2 different arms, it's time to lower the size of your arms. Keep moving the Gold block down/up your arm to pinpoint the location of the player you want to track. If he doesn't show up anymore after you moved the Gold block, place the block higher up until you are at a 1 block difference. Now all that is left is to add the length of the arm from the respective coordinate on your Diamond block and you've found the location of an enemy within 25 blocks!", (ChatFormatting)ChatFormatting.GRAY);
                return 1;
            }
            MessageFunctions.sendMessage((Player)player, (String)"Tracking Help Page (1/5)", (ChatFormatting)ChatFormatting.DARK_GRAY, (boolean)true);
            MessageFunctions.sendMessage((Player)player, (String)"For an introduction to tracking read page 2.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"For information on building a tracker read page 3.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"For explanation on '/track all' read page 4.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"For explanation on '/track [playerName]' read page 5.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"To select a page: '/track help [page]'", (ChatFormatting)ChatFormatting.GRAY);
            return 1;
        })))).then(Commands.literal((String)"help").then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)3, (int)3)).then(Commands.literal((String)"layout").executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).getPlayerOrException();
            MessageFunctions.sendMessage((Player)player, (String)"Tracking Help Page (3/5) - Building LAYOUT", (ChatFormatting)ChatFormatting.DARK_GRAY, (boolean)true);
            MessageFunctions.sendMessage((Player)player, (String)"In the picture below you can see multiple letters and dashes. The dashes are Obsidian blocks, D is a Diamond block, and G are Gold blocks.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"         G", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"         |", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"    G--D--G ", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"         |", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"         G", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"", (ChatFormatting)ChatFormatting.GRAY);
            return 1;
        }))))).then(Commands.literal((String)"all").executes(command -> {
            BlockPos bpos;
            ServerPlayer player = ((CommandSourceStack)command.getSource()).getPlayerOrException();
            Level world = player.level();
            Block block = world.getBlockState(bpos = player.blockPosition().below().immutable()).getBlock();
            if (block.equals(Blocks.DIAMOND_BLOCK)) {
                Tracking tracker = new Tracking();
                tracker.setLoc(bpos.getX(), bpos.getY(), bpos.getZ());
                tracker.Track((Player)player, null);
                return 1;
            }
            if (block.equals(Blocks.OBSIDIAN)) {
                MessageFunctions.sendMessage((Player)player, (String)"You cannot track all with this type of tracker", (ChatFormatting)ChatFormatting.GRAY);
                return 1;
            }
            MessageFunctions.sendMessage((Player)player, (String)"You need to be on a solid tracker to '/track all'", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"Do '/track help' for more information.", (ChatFormatting)ChatFormatting.GRAY);
            return 1;
        }))).then(Commands.argument((String)"playerName", (ArgumentType)StringArgumentType.string()).executes(command -> {
            String playername;
            ServerPlayer player = ((CommandSourceStack)command.getSource()).getPlayerOrException();
            Player other = PlayerFunctions.matchPlayer((Player)player, (String)(playername = StringArgumentType.getString((CommandContext)command, (String)"playerName")));
            if (other != null) {
                Tracking tracker = new Tracking();
                BlockPos bpos = player.blockPosition().below().immutable();
                tracker.setLoc(bpos.getX(), bpos.getY(), bpos.getZ());
                tracker.Track((Player)player, other);
                return 1;
            }
            MessageFunctions.sendMessage((Player)player, (String)("Could not find player '" + playername + "'."), (ChatFormatting)ChatFormatting.GRAY);
            return 1;
        }))).executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).getPlayerOrException();
            MessageFunctions.sendMessage((Player)player, (String)"Use '/track [playerName]'  or '/track all'.", (ChatFormatting)ChatFormatting.GRAY);
            MessageFunctions.sendMessage((Player)player, (String)"Or do '/track help' for information.", (ChatFormatting)ChatFormatting.GRAY);
            return 1;
        }));
    }
}

