/*
 * Decompiled with CFR 0.152.
 */
package com.akicater.blocks;

import com.akicater.Ipla;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayingItemEntity
extends BlockEntity {
    public NonNullList<ItemStack> inv = NonNullList.withSize((int)24, (Object)ItemStack.EMPTY);
    public NonNullList<Float> rot = NonNullList.withSize((int)24, (Object)Float.valueOf(0.0f));
    public NonNullList<Float> lastRot = NonNullList.withSize((int)24, (Object)Float.valueOf(0.0f));
    public NonNullList<Boolean> quad = NonNullList.withSize((int)6, (Object)false);

    public LayingItemEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)Ipla.lItemBlockEntity.get(), pos, blockState);
    }

    public void load(CompoundTag compoundTag) {
        int i;
        super.load(compoundTag);
        this.inv.clear();
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.inv);
        for (i = 0; i < 6; ++i) {
            this.quad.set(i, (Object)compoundTag.getBoolean("s" + i));
        }
        for (i = 0; i < 24; ++i) {
            this.rot.set(i, (Object)Float.valueOf(compoundTag.getFloat("r" + i)));
        }
    }

    @NotNull
    public void saveAdditional(CompoundTag compoundTag) {
        int i;
        super.saveAdditional(compoundTag);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.inv);
        for (i = 0; i < 6; ++i) {
            compoundTag.putBoolean("s" + i, ((Boolean)this.quad.get(i)).booleanValue());
        }
        for (i = 0; i < 24; ++i) {
            compoundTag.putFloat("r" + i, ((Float)this.rot.get(i)).floatValue());
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag compoundTag = this.saveWithoutMetadata();
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.inv);
        return compoundTag;
    }

    public void setItem(int index, ItemStack stack) {
        this.inv.set(index, (Object)stack.split(1));
    }

    public VoxelShape getShape() {
        ArrayList<VoxelShape> tempShape = new ArrayList<VoxelShape>();
        if (!this.isSlotEmpty(0)) {
            tempShape.add(Shapes.box((double)0.125, (double)0.875, (double)0.125, (double)0.875, (double)1.0, (double)0.875));
        }
        if (!this.isSlotEmpty(1)) {
            tempShape.add(Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)0.875));
        }
        if (!this.isSlotEmpty(2)) {
            tempShape.add(Shapes.box((double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875, (double)1.0));
        }
        if (!this.isSlotEmpty(3)) {
            tempShape.add(Shapes.box((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.125));
        }
        if (!this.isSlotEmpty(4)) {
            tempShape.add(Shapes.box((double)0.875, (double)0.125, (double)0.125, (double)1.0, (double)0.875, (double)0.875));
        }
        if (!this.isSlotEmpty(5)) {
            tempShape.add(Shapes.box((double)0.0, (double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875));
        }
        Optional shape = tempShape.stream().reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR));
        return shape.orElseGet(() -> Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.1, (double)1.0));
    }

    public boolean isSlotEmpty(int slot) {
        for (int i = slot * 4; i < slot * 4 + 4; ++i) {
            if (((ItemStack)this.inv.get(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.inv) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void markDirty() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void markDirty(@Nullable Entity entity) {
        this.level.gameEvent(GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
        this.markDirty();
    }
}

