/*
 * Decompiled with CFR 0.152.
 */
package com.akicater.blocks;

import com.akicater.Ipla;
import com.akicater.blocks.LayingItemEntity;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LayingItem
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<LayingItem> CODEC = LayingItem.simpleCodec(LayingItem::new);
    public static BooleanProperty WATERLOGGED = BooleanProperty.create((String)"waterlogged");

    public LayingItem(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public BlockState updateShape(BlockState blockState, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos blockPos, Direction direction, BlockPos arg6, BlockState arg7, RandomSource arg8) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        return super.updateShape(blockState, levelReader, scheduledTickAccess, blockPos, direction, arg6, arg7, arg8);
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public LayingItemEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LayingItemEntity(pos, state);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        LayingItemEntity entity = (LayingItemEntity)level.getBlockEntity(pos);
        if (entity != null) {
            return entity.getShape();
        }
        return super.getShape(state, level, pos, context);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            LayingItemEntity entity = (LayingItemEntity)level.getBlockEntity(pos);
            if (entity != null && !entity.isEmpty()) {
                for (int i = 0; i < 24; ++i) {
                    ItemStack itemStack = (ItemStack)entity.inv.get(i);
                    if (itemStack.isEmpty()) continue;
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemStack);
                }
                entity.inv.clear();
                entity.setRemoved();
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        LayingItemEntity entity = (LayingItemEntity)level.getBlockEntity(pos);
        if (entity != null) {
            Pair<Integer, Integer> pair = Ipla.getIndexFromHit(hit, false);
            int s = (Integer)pair.getFirst();
            int i = (Integer)pair.getSecond();
            if (!((Boolean)entity.quad.get(s)).booleanValue()) {
                i = 0;
            }
            if (((ItemStack)entity.inv.get(s * 4 + i)).isEmpty()) {
                return InteractionResult.FAIL;
            }
            ItemStack itemStack = ((ItemStack)entity.inv.get(s * 4 + i)).copy();
            boolean success = player.addItem(itemStack);
            if (success && itemStack.isEmpty()) {
                entity.inv.set(s * 4 + i, (Object)ItemStack.EMPTY);
                entity.markDirty((Entity)player);
                level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BUNDLE_REMOVE_ONE, SoundSource.BLOCKS, 1.0f, 1.4f);
                if (entity.isEmpty()) {
                    level.removeBlock(pos, false);
                    entity.setRemoved();
                } else if (entity.isSlotEmpty(s)) {
                    entity.quad.set(s, (Object)false);
                }
                entity.markDirty((Entity)player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    static {
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
    }
}

