/*
 * Decompiled with CFR 0.152.
 */
package com.akicater.client;

import com.akicater.blocks.LayingItemEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class LayingItemBER_abstract_common
implements BlockEntityRenderer<LayingItemEntity> {
    public static List<Quaternionf> rot = new ArrayList<Quaternionf>(List.of(Axis.XP.rotationDegrees(90.0f), Axis.XN.rotationDegrees(90.0f), Axis.YP.rotationDegrees(180.0f), Axis.YP.rotationDegrees(0.0f), Axis.YP.rotationDegrees(270.0f), Axis.YP.rotationDegrees(90.0f)));
    public static Vec3 pos1 = new Vec3(0.5, 0.5, 0.0);

    public LayingItemBER_abstract_common(BlockEntityRendererProvider.Context context) {
    }

    public void render(LayingItemEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, Vec3 cameraPos, float itemSize, float blockSize, float absoluteSize, boolean oldRendering, float dt) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        for (int s = 0; s < 6; ++s) {
            float bSize;
            float iSize;
            if (((Boolean)entity.quad.get(s)).booleanValue()) {
                iSize = itemSize * absoluteSize / 2.0f;
                bSize = blockSize * absoluteSize / 2.0f;
                for (int i = 0; i < 4; ++i) {
                    if (((ItemStack)entity.inv.get(s * 4 + i)).isEmpty()) continue;
                    ItemStack stack = (ItemStack)entity.inv.get(s * 4 + i);
                    poseStack.pushPose();
                    boolean fullBlock = stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock().defaultBlockState().isCollisionShapeFullBlock((BlockGetter)entity.getLevel(), entity.getBlockPos());
                    this.manipStack(poseStack, entity, fullBlock, oldRendering, iSize, bSize, s, i, dt);
                    if (fullBlock) {
                        poseStack.scale(bSize, bSize, bSize);
                    } else {
                        poseStack.scale(iSize, iSize, iSize);
                    }
                    itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, entity.getLevel(), 1);
                    poseStack.popPose();
                }
                continue;
            }
            if (((ItemStack)entity.inv.get(s * 4)).isEmpty()) continue;
            iSize = itemSize * absoluteSize;
            bSize = blockSize * absoluteSize;
            ItemStack stack = (ItemStack)entity.inv.get(s * 4);
            poseStack.pushPose();
            boolean fullBlock = stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock().defaultBlockState().isCollisionShapeFullBlock((BlockGetter)entity.getLevel(), entity.getBlockPos());
            this.manipStack(poseStack, entity, fullBlock, oldRendering, iSize, bSize, s, 4, dt);
            if (fullBlock) {
                poseStack.scale(bSize, bSize, bSize);
            } else {
                poseStack.scale(iSize, iSize, iSize);
            }
            itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, entity.getLevel(), 1);
            poseStack.popPose();
        }
    }

    float lerp(float a, float b, float f) {
        return a * (1.0f - f) + b * f;
    }

    public void manipStack(PoseStack poseStack, LayingItemEntity entity, boolean fullBlock, boolean oldRendering, float iSize, float bSize, int s, int i, float dt) {
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)rot.get(s));
        boolean quad = i < 4;
        int x = s * 4 + (quad ? i : 0);
        float rotation = Math.lerp((float)((Float)entity.lastRot.get(x)).floatValue(), (float)((Float)entity.rot.get(x)).floatValue(), (float)(0.1f * dt));
        if (fullBlock && !oldRendering) {
            poseStack.translate(-0.5, -0.5, -0.5);
            if (quad) {
                poseStack.translate(0.25f + ((i + 1) % 2 == 0 ? 0.5f : 0.0f), 0.25f + (i > 1 ? 0.5f : 0.0f), 0.25f * bSize);
            } else {
                poseStack.translate(LayingItemBER_abstract_common.pos1.x, LayingItemBER_abstract_common.pos1.y, (double)(0.25f * bSize));
            }
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(rotation));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        } else {
            poseStack.translate(-0.5, -0.5, -0.5);
            if (quad) {
                poseStack.translate(0.25f + ((i + 1) % 2 == 0 ? 0.5f : 0.0f), 0.25f + (i > 1 ? 0.5f : 0.0f), 0.03125f * iSize);
            } else {
                poseStack.translate(LayingItemBER_abstract_common.pos1.x, LayingItemBER_abstract_common.pos1.y, (double)(0.03125f * iSize));
            }
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(rotation));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        }
        entity.lastRot.set(x, (Object)Float.valueOf(rotation));
    }

    public abstract void render(LayingItemEntity var1, float var2, PoseStack var3, MultiBufferSource var4, int var5, int var6, Vec3 var7);
}

