/*
 * Decompiled with CFR 0.152.
 */
package com.akicater.network;

import com.akicater.Ipla;
import com.akicater.blocks.LayingItemEntity;
import com.mojang.datafixers.util.Pair;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public record ItemRotatePayload(float degrees, int y, boolean rounded, BlockHitResult hitResult) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ItemRotatePayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"ipla", (String)"rotate_item"));
    public static final StreamCodec<FriendlyByteBuf, ItemRotatePayload> CODEC = StreamCodec.of((buf, value) -> buf.writeFloat(value.degrees).writeInt(value.y).writeBoolean(value.rounded).writeBlockHitResult(value.hitResult), buf -> new ItemRotatePayload(buf.readFloat(), buf.readInt(), buf.readBoolean(), buf.readBlockHitResult()));

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void receive(Player player, float degrees, int y, boolean rounded, BlockHitResult hitResult) {
        Level level = player.level();
        LayingItemEntity entity = (LayingItemEntity)level.getChunk(hitResult.getBlockPos()).getBlockEntity(hitResult.getBlockPos());
        if (entity != null) {
            Pair<Integer, Integer> pair = Ipla.getIndexFromHit(hitResult, false);
            boolean quad = (Boolean)entity.quad.get(((Integer)pair.getFirst()).intValue());
            int x = (Integer)pair.getFirst() * 4 + (quad ? (Integer)pair.getSecond() : 0);
            if (rounded) {
                entity.rot.set(x, (Object)Float.valueOf(((Float)entity.rot.get(x)).floatValue() - ((Float)entity.rot.get(x)).floatValue() % 22.5f + 22.5f * (float)y));
            } else {
                entity.rot.set(x, (Object)Float.valueOf(((Float)entity.rot.get(x)).floatValue() + degrees * (float)y));
            }
            entity.markDirty();
        }
    }
}

