/*
 * Decompiled with CFR 0.152.
 */
package com.akicater;

import com.akicater.blocks.LayingItem;
import com.akicater.blocks.LayingItemEntity;
import com.akicater.client.IplaConfig;
import com.akicater.network.ItemPlacePayload;
import com.akicater.network.ItemRotatePayload;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.logging.Logger;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_7924;
import net.minecraft.class_8710;

public final class Ipla {
    public static final String MOD_ID = "ipla";
    public static final Logger LOGGER = Logger.getLogger("ipla");
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));
    public static final Registrar<class_2248> blocks = MANAGER.get().get(class_7924.field_41254);
    public static final Registrar<class_2591<?>> blockEntities = MANAGER.get().get(class_7924.field_41255);
    public static RegistrySupplier<LayingItem> lItemBlock;
    public static RegistrySupplier<class_2591<LayingItemEntity>> lItemBlockEntity;
    public static class_304 PLACE_ITEM_KEY;
    public static class_304 ROTATE_ITEM_KEY;
    public static class_304 ROTATE_ROUNDED_ITEM_KEY;
    public static final Random RANDOM;
    public static class_2960 ITEM_PLACE;
    public static class_2960 ITEM_ROTATE;
    static List<class_238> boxes;

    public static void initializeServer() {
        lItemBlock = blocks.register(class_2960.method_60655((String)MOD_ID, (String)"l_item"), () -> new LayingItem(class_4970.class_2251.method_9637().method_9618().method_9624().method_22488()));
        lItemBlockEntity = blockEntities.register(class_2960.method_60655((String)MOD_ID, (String)"l_item_entity"), () -> class_2591.class_2592.method_20528(LayingItemEntity::new, (class_2248[])new class_2248[]{(class_2248)lItemBlock.get()}).method_11034(null));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, ItemPlacePayload.TYPE, ItemPlacePayload.CODEC, (buf, context) -> ItemPlacePayload.receive(context.getPlayer(), buf.pos(), buf.hitResult()));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, ItemRotatePayload.TYPE, ItemRotatePayload.CODEC, (buf, context) -> ItemRotatePayload.receive(context.getPlayer(), buf.degrees(), buf.y(), buf.rounded(), buf.hitResult()));
    }

    public static void initializeClient() {
        PLACE_ITEM_KEY = new class_304("key.ipla.place_item_key", class_3675.class_307.field_1668, 86, "key.categories.ipla");
        ROTATE_ITEM_KEY = new class_304("key.ipla.rotate_item_key", class_3675.class_307.field_1668, 342, "key.categories.ipla");
        ROTATE_ROUNDED_ITEM_KEY = new class_304("key.ipla.rotate_rounded_item_key", class_3675.class_307.field_1668, 90, "key.categories.ipla");
        KeyMappingRegistry.register((class_304)PLACE_ITEM_KEY);
        KeyMappingRegistry.register((class_304)ROTATE_ITEM_KEY);
        KeyMappingRegistry.register((class_304)ROTATE_ROUNDED_ITEM_KEY);
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (PLACE_ITEM_KEY.method_1436() && client.field_1765 instanceof class_3965 && client.field_1724.method_5998(class_1268.field_5808) != class_1799.field_8037 && class_310.method_1551().field_1687.method_8320(((class_3965)client.field_1765).method_17777()).method_26204() != class_2246.field_10124) {
                ItemPlacePayload payload = new ItemPlacePayload(((class_3965)client.field_1765).method_17777(), (class_3965)client.field_1765);
                NetworkManager.sendToServer((class_8710)payload);
            }
        });
        ClientRawInputEvent.MOUSE_SCROLLED.register((minecraft, x, y) -> {
            class_3965 hitResult = Ipla.getBlockHitResult(minecraft.field_1765);
            boolean rounded = false;
            if (hitResult != null && ROTATE_ITEM_KEY.method_1434()) {
                if (ROTATE_ROUNDED_ITEM_KEY.method_1434()) {
                    rounded = true;
                }
                if (minecraft.field_1687 != null && minecraft.field_1687.method_8320(hitResult.method_17777()).method_26204() == lItemBlock) {
                    ItemRotatePayload payload = new ItemRotatePayload(RANDOM.nextFloat(18.0f, 22.0f), (int)y, rounded, hitResult);
                    NetworkManager.sendToServer((class_8710)payload);
                    if (Platform.isForgeLike()) {
                        return EventResult.interruptFalse();
                    }
                    return EventResult.interruptTrue();
                }
            }
            return EventResult.interruptDefault();
        });
        ClientLifecycleEvent.CLIENT_STARTED.register(minecraft -> IplaConfig.HANDLER.load());
        ClientLifecycleEvent.CLIENT_STOPPING.register(minecraft -> IplaConfig.HANDLER.save());
    }

    public static class_3965 getBlockHitResult(class_239 hit) {
        if (hit.method_17783() == class_239.class_240.field_1332) {
            return (class_3965)hit;
        }
        return null;
    }

    static boolean contains(float x, float y, float z, class_238 box) {
        return (double)x >= box.field_1323 && (double)x <= box.field_1320 && (double)y >= box.field_1322 && (double)y <= box.field_1325 && (double)z >= box.field_1321 && (double)z <= box.field_1324;
    }

    public static int getSlotFromShape(float x, float y, float z) {
        for (int i = 0; i < boxes.size(); ++i) {
            if (!Ipla.contains(x, y, z, boxes.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static Pair<Integer, Integer> getIndexFromHit(class_3965 hit, Boolean empty) {
        class_2338 blockPos = hit.method_17777();
        class_243 pos = hit.method_17784();
        float x = (float)Math.abs(pos.field_1352 - (double)blockPos.method_10263());
        float y = (float)Math.abs(pos.field_1351 - (double)blockPos.method_10264());
        float z = (float)Math.abs(pos.field_1350 - (double)blockPos.method_10260());
        int slot = empty != false ? hit.method_17780().method_10146() : Ipla.getSlotFromShape(x, y, z);
        switch (slot) {
            case 0: 
            case 1: {
                return new Pair((Object)slot, (Object)(slot == 1 ? Ipla.getIndexFromXY(x, 1.0f - z) : Ipla.getIndexFromXY(x, z)));
            }
            case 2: 
            case 3: {
                return new Pair((Object)slot, (Object)(slot == 2 ? Ipla.getIndexFromXY(1.0f - x, y) : Ipla.getIndexFromXY(x, y)));
            }
            case 4: 
            case 5: {
                return new Pair((Object)slot, (Object)(slot == 5 ? Ipla.getIndexFromXY(1.0f - z, y) : Ipla.getIndexFromXY(z, y)));
            }
        }
        return new Pair((Object)0, (Object)0);
    }

    private static int getIndexFromXY(float a, float b) {
        return (a > 0.5f ? 1 : 0) + (b > 0.5f ? 2 : 0);
    }

    static {
        RANDOM = new Random();
        boxes = new ArrayList<class_238>(List.of(new class_238(0.125, 0.875, 0.125, 0.875, 1.0, 0.875), new class_238(0.125, 0.0, 0.125, 0.875, 0.125, 0.875), new class_238(0.125, 0.125, 0.875, 0.875, 0.875, 1.0), new class_238(0.125, 0.125, 0.0, 0.875, 0.875, 0.125), new class_238(0.875, 0.125, 0.125, 1.0, 0.875, 0.875), new class_238(0.0, 0.125, 0.125, 0.125, 0.875, 0.875)));
    }
}

