/*
 * Decompiled with CFR 0.152.
 */
package com.akicater;

import com.akicater.blocks.LayingItem;
import com.akicater.blocks.LayingItemEntity;
import com.akicater.client.IplaConfig;
import com.akicater.network.ItemPlacePayload;
import com.akicater.network.ItemRotatePayload;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import eu.midnightdust.lib.config.MidnightConfig;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.logging.Logger;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class Ipla {
    public static final String MOD_ID = "ipla";
    public static final Logger LOGGER = Logger.getLogger("ipla");
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));
    public static final Registrar<Block> blocks = MANAGER.get().get(Registries.f_256747_);
    public static final Registrar<BlockEntityType<?>> blockEntities = MANAGER.get().get(Registries.f_256922_);
    public static RegistrySupplier<LayingItem> lItemBlock;
    public static RegistrySupplier<BlockEntityType<LayingItemEntity>> lItemBlockEntity;
    public static KeyMapping PLACE_ITEM_KEY;
    public static KeyMapping ROTATE_ITEM_KEY;
    public static KeyMapping ROTATE_ROUNDED_ITEM_KEY;
    public static final Random RANDOM;
    public static ResourceLocation ITEM_PLACE;
    public static ResourceLocation ITEM_ROTATE;
    static List<AABB> boxes;

    public static void initializeServer() {
        lItemBlock = blocks.register(new ResourceLocation(MOD_ID, "l_item"), () -> new LayingItem(BlockBehaviour.Properties.m_60939_((Material)Material.f_76296_).m_60966_().m_60988_().m_60955_()));
        lItemBlockEntity = blockEntities.register(new ResourceLocation(MOD_ID, "l_item_entity"), () -> BlockEntityType.Builder.m_155273_(LayingItemEntity::new, (Block[])new Block[]{(Block)lItemBlock.get()}).m_58966_(null));
        ITEM_PLACE = new ResourceLocation(MOD_ID, "place_item");
        ITEM_ROTATE = new ResourceLocation(MOD_ID, "rotate_item");
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)ITEM_PLACE, (buf, context) -> ItemPlacePayload.receive(context.getPlayer(), buf.m_130135_(), buf.m_130283_()));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)ITEM_ROTATE, (buf, context) -> ItemRotatePayload.receive(context.getPlayer(), buf.readFloat(), buf.readInt(), buf.readBoolean(), buf.m_130283_()));
    }

    public static void initializeClient() {
        MidnightConfig.init((String)MOD_ID, IplaConfig.class);
        PLACE_ITEM_KEY = new KeyMapping("key.ipla.place_item_key", InputConstants.Type.KEYSYM, 86, "key.categories.ipla");
        ROTATE_ITEM_KEY = new KeyMapping("key.ipla.rotate_item_key", InputConstants.Type.KEYSYM, 342, "key.categories.ipla");
        ROTATE_ROUNDED_ITEM_KEY = new KeyMapping("key.ipla.rotate_rounded_item_key", InputConstants.Type.KEYSYM, 90, "key.categories.ipla");
        KeyMappingRegistry.register((KeyMapping)PLACE_ITEM_KEY);
        KeyMappingRegistry.register((KeyMapping)ROTATE_ITEM_KEY);
        KeyMappingRegistry.register((KeyMapping)ROTATE_ROUNDED_ITEM_KEY);
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (PLACE_ITEM_KEY.m_90859_() && client.f_91077_ instanceof BlockHitResult && client.f_91074_.m_21120_(InteractionHand.MAIN_HAND) != ItemStack.f_41583_ && Minecraft.m_91087_().f_91073_.m_8055_(((BlockHitResult)client.f_91077_).m_82425_()).m_60734_() != Blocks.f_50016_) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130064_(((BlockHitResult)client.f_91077_).m_82425_());
                buf.m_130062_((BlockHitResult)client.f_91077_);
                NetworkManager.sendToServer((ResourceLocation)ITEM_PLACE, (FriendlyByteBuf)buf);
            }
        });
        ClientRawInputEvent.MOUSE_SCROLLED.register((minecraft, y) -> {
            BlockHitResult hitResult = Ipla.getBlockHitResult(minecraft.f_91077_);
            boolean rounded = false;
            if (hitResult != null && ROTATE_ITEM_KEY.m_90857_()) {
                if (ROTATE_ROUNDED_ITEM_KEY.m_90857_()) {
                    rounded = true;
                }
                if (minecraft.f_91073_ != null && minecraft.f_91073_.m_8055_(hitResult.m_82425_()).m_60734_() == lItemBlock) {
                    FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                    buf.writeFloat(RANDOM.nextFloat(18.0f, 22.0f));
                    buf.writeInt((int)y);
                    buf.writeBoolean(rounded);
                    buf.m_130062_(hitResult);
                    NetworkManager.sendToServer((ResourceLocation)ITEM_ROTATE, (FriendlyByteBuf)buf);
                    if (Platform.isForge()) {
                        return EventResult.interruptFalse();
                    }
                    return EventResult.interruptTrue();
                }
            }
            return EventResult.interruptDefault();
        });
    }

    public static BlockHitResult getBlockHitResult(HitResult hit) {
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            return (BlockHitResult)hit;
        }
        return null;
    }

    static boolean contains(float x, float y, float z, AABB box) {
        return (double)x >= box.f_82288_ && (double)x <= box.f_82291_ && (double)y >= box.f_82289_ && (double)y <= box.f_82292_ && (double)z >= box.f_82290_ && (double)z <= box.f_82293_;
    }

    public static int getSlotFromShape(float x, float y, float z) {
        for (int i = 0; i < boxes.size(); ++i) {
            if (!Ipla.contains(x, y, z, boxes.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static Pair<Integer, Integer> getIndexFromHit(BlockHitResult hit, Boolean empty) {
        BlockPos blockPos = hit.m_82425_();
        Vec3 pos = hit.m_82450_();
        float x = (float)Math.abs(pos.f_82479_ - (double)blockPos.m_123341_());
        float y = (float)Math.abs(pos.f_82480_ - (double)blockPos.m_123342_());
        float z = (float)Math.abs(pos.f_82481_ - (double)blockPos.m_123343_());
        int slot = empty != false ? hit.m_82434_().m_122411_() : Ipla.getSlotFromShape(x, y, z);
        switch (slot) {
            case 0: 
            case 1: {
                return new Pair((Object)slot, (Object)(slot == 1 ? Ipla.getIndexFromXY(x, 1.0f - z) : Ipla.getIndexFromXY(x, z)));
            }
            case 2: 
            case 3: {
                return new Pair((Object)slot, (Object)(slot == 2 ? Ipla.getIndexFromXY(1.0f - x, y) : Ipla.getIndexFromXY(x, y)));
            }
            case 4: 
            case 5: {
                return new Pair((Object)slot, (Object)(slot == 5 ? Ipla.getIndexFromXY(1.0f - z, y) : Ipla.getIndexFromXY(z, y)));
            }
        }
        return new Pair((Object)0, (Object)0);
    }

    private static int getIndexFromXY(float a, float b) {
        return (a > 0.5f ? 1 : 0) + (b > 0.5f ? 2 : 0);
    }

    static {
        RANDOM = new Random();
        boxes = new ArrayList<AABB>(List.of(new AABB(0.125, 0.875, 0.125, 0.875, 1.0, 0.875), new AABB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875), new AABB(0.125, 0.125, 0.875, 0.875, 0.875, 1.0), new AABB(0.125, 0.125, 0.0, 0.875, 0.875, 0.125), new AABB(0.875, 0.125, 0.125, 1.0, 0.875, 0.875), new AABB(0.0, 0.125, 0.125, 0.125, 0.875, 0.875)));
    }
}

