/*
 * Decompiled with CFR 0.152.
 */
package com.akicater.blocks;

import com.akicater.Ipla;
import com.akicater.blocks.LayingItemEntity;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LayingItem
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static BooleanProperty WATERLOGGED = BooleanProperty.m_61465_((String)"waterlogged");

    public LayingItem(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public LayingItemEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LayingItemEntity(pos, state);
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        LayingItemEntity entity = (LayingItemEntity)level.m_7702_(pos);
        if (entity != null) {
            return entity.getShape();
        }
        return super.m_5940_(state, level, pos, context);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.m_60713_(newState.m_60734_())) {
            LayingItemEntity entity = (LayingItemEntity)level.m_46865_(pos).m_7702_(pos);
            if (entity != null && !entity.isEmpty()) {
                for (int i = 0; i < 24; ++i) {
                    ItemStack itemStack = (ItemStack)entity.inv.get(i);
                    if (itemStack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
                }
                entity.inv.clear();
                entity.m_7651_();
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, movedByPiston);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        LayingItemEntity entity = (LayingItemEntity)level.m_46865_(pos).m_7702_(pos);
        if (entity != null) {
            Pair<Integer, Integer> pair = Ipla.getIndexFromHit(hit, false);
            int s = (Integer)pair.getFirst();
            int i = (Integer)pair.getSecond();
            if (!((Boolean)entity.quad.get(s)).booleanValue()) {
                i = 0;
            }
            if (((ItemStack)entity.inv.get(s * 4 + i)).m_41619_()) {
                return InteractionResult.FAIL;
            }
            ItemStack itemStack = ((ItemStack)entity.inv.get(s * 4 + i)).m_41777_();
            boolean success = player.m_36356_(itemStack);
            if (success && itemStack.m_41619_()) {
                entity.inv.set(s * 4 + i, (Object)ItemStack.f_41583_);
                entity.markDirty((Entity)player);
                level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_184216_, SoundSource.BLOCKS, 1.0f, 1.4f);
                if (entity.isEmpty()) {
                    level.m_7471_(pos, false);
                    entity.m_7651_();
                } else if (entity.isSlotEmpty(s)) {
                    entity.quad.set(s, (Object)false);
                }
                entity.markDirty((Entity)player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    static {
        WATERLOGGED = BlockStateProperties.f_61362_;
    }
}

