/*
 * Decompiled with CFR 0.152.
 */
package me.drex.seedguard;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_5218;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7059;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeedManager {
    private static final Codec<Map<class_6880<class_7059>, Integer>> STRUCTURE_SEEDS_MAP_CODEC = Codec.unboundedMap((Codec)class_7059.field_37196, (Codec)Codec.INT);
    private static final Codec<Map<class_6880<class_2975<?, ?>>, Long>> FEATURE_SEEDS_MAP_CODEC = Codec.unboundedMap((Codec)class_2975.field_24833, (Codec)Codec.LONG);
    private static final Codec<Map<class_2960, Long>> SURFACE_RULE_SEEDS_MAP_CODEC = Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.LONG);
    private static final String STRUCTURE_SEEDS_FILE = "structure-seeds.json";
    private static final String FEATURE_SEEDS_FILE = "feature-seeds.json";
    private static final String SURFACE_RULE_SEEDS_FILE = "surface-rule-seeds.json";
    private static final String[] VANILLA_SURFACE_RULES = new String[]{"bedrock_roof", "bedrock_floor", "deepslate"};
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final SecureRandom random = new SecureRandom();
    private static final Reference2IntMap<class_6880<class_7059>> structureSeeds = new Reference2IntOpenHashMap();
    private static final Reference2LongMap<class_6880<class_2975<?, ?>>> featureSeeds = new Reference2LongOpenHashMap();
    private static final Object2LongMap<class_2960> surfaceRuleSeeds = new Object2LongOpenHashMap();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SeedManager");

    public static void load(MinecraftServer server) {
        structureSeeds.clear();
        featureSeeds.clear();
        surfaceRuleSeeds.clear();
        structureSeeds.putAll(SeedManager.load(server, STRUCTURE_SEEDS_FILE, STRUCTURE_SEEDS_MAP_CODEC));
        featureSeeds.putAll(SeedManager.load(server, FEATURE_SEEDS_FILE, FEATURE_SEEDS_MAP_CODEC));
        surfaceRuleSeeds.putAll(SeedManager.load(server, SURFACE_RULE_SEEDS_FILE, SURFACE_RULE_SEEDS_MAP_CODEC));
        server.method_30611().method_30530(class_7924.field_41248).method_42017().forEach(holder -> structureSeeds.computeIfAbsent(holder, ignored -> random.nextInt()));
        server.method_30611().method_30530(class_7924.field_41239).method_42017().forEach(holder -> featureSeeds.computeIfAbsent(holder, ignored -> random.nextLong()));
        for (String vanillaSurfaceRule : VANILLA_SURFACE_RULES) {
            surfaceRuleSeeds.computeIfAbsent((Object)class_2960.method_60654((String)vanillaSurfaceRule), ignored -> random.nextLong());
        }
        SeedManager.save(server);
    }

    private static <T, U> Map<T, U> load(MinecraftServer server, String filePath, Codec<Map<T, U>> codec) {
        Path savePath = server.method_27050(class_5218.field_24188).resolve(filePath);
        if (Files.isRegularFile(savePath, new LinkOption[0])) {
            Map map;
            JsonReader jsonReader = new JsonReader((Reader)Files.newBufferedReader(savePath, StandardCharsets.UTF_8));
            try {
                jsonReader.setLenient(false);
                JsonElement jsonElement = JsonParser.parseReader((JsonReader)jsonReader);
                DataResult result = codec.parse((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)server.method_30611()), (Object)jsonElement);
                map = (Map)result.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            jsonReader.close();
            return map;
        }
        return Collections.emptyMap();
    }

    public static int getStructureSeed(class_6880<class_7059> holder) {
        return structureSeeds.getInt(holder);
    }

    public static long getFeatureSeed(class_6880<class_2975<?, ?>> holder) {
        return featureSeeds.getLong(holder);
    }

    public static Optional<Long> getSurfaceRuleSeed(class_2960 resourceLocation) {
        if (surfaceRuleSeeds.containsKey((Object)resourceLocation)) {
            return Optional.of(surfaceRuleSeeds.getLong((Object)resourceLocation));
        }
        return Optional.empty();
    }

    public static void save(MinecraftServer server) {
        SeedManager.save(server, STRUCTURE_SEEDS_FILE, STRUCTURE_SEEDS_MAP_CODEC, structureSeeds);
        SeedManager.save(server, FEATURE_SEEDS_FILE, FEATURE_SEEDS_MAP_CODEC, featureSeeds);
        SeedManager.save(server, SURFACE_RULE_SEEDS_FILE, SURFACE_RULE_SEEDS_MAP_CODEC, surfaceRuleSeeds);
    }

    private static <T, U> void save(MinecraftServer server, String filePath, Codec<Map<T, U>> codec, Map<T, U> data) {
        Path savePath = server.method_27050(class_5218.field_24188).resolve(filePath);
        DataResult result = codec.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)server.method_30611()), data);
        JsonElement jsonElement = (JsonElement)result.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow();
        try (BufferedWriter writer = Files.newBufferedWriter(savePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson(jsonElement, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save \"{}\"", (Object)savePath, (Object)e);
        }
    }
}

