/*
 * Decompiled with CFR 0.152.
 */
package com.kronichiwa.utils;

import com.kronichiwa.BeaconGradient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class ColorUtils {
    public static final LinkedHashMap<String, String> DYE_HEX;
    public static final LinkedHashMap<String, float[]> PALETTE;

    public static float[] hexToRgb(String hexVal) {
        String s = hexVal.startsWith("#") ? hexVal.substring(1) : hexVal;
        int r = Integer.parseInt(s.substring(0, 2), 16);
        int g = Integer.parseInt(s.substring(2, 4), 16);
        int b = Integer.parseInt(s.substring(4, 6), 16);
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static float[] parseColorInput(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null");
        }
        String s = color.trim();
        String lower = s.toLowerCase(Locale.ROOT);
        if (PALETTE.containsKey(lower)) {
            return PALETTE.get(lower);
        }
        if (s.startsWith("#") && (s.length() == 7 || s.length() == 6) || s.length() == 6 && s.matches("[0-9A-Fa-f]{6}")) {
            return ColorUtils.hexToRgb((String)(s.startsWith("#") ? s : "#" + s));
        }
        if (s.contains(",")) {
            String[] parts = s.split(",");
            if (parts.length < 3) {
                throw new IllegalArgumentException("RGB input must have three components");
            }
            float[] vals = new float[3];
            for (int i = 0; i < 3; ++i) {
                vals[i] = Float.parseFloat(parts[i].trim());
            }
            float max = Math.max(vals[0], Math.max(vals[1], vals[2]));
            if (max > 1.0f) {
                for (int i = 0; i < 3; ++i) {
                    vals[i] = vals[i] / 255.0f;
                }
            }
            return vals;
        }
        String maybeHex = s.replaceAll("^#", "");
        if (maybeHex.length() == 6 && maybeHex.matches("[0-9A-Fa-f]{6}")) {
            return ColorUtils.hexToRgb("#" + maybeHex);
        }
        throw new IllegalArgumentException("Can't parse color input: " + color);
    }

    public static float[] seqMixToColor(List<float[]> seqRgb) {
        if (seqRgb == null || seqRgb.isEmpty()) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        float[] color = Arrays.copyOf(seqRgb.get(0), 3);
        for (int i = 1; i < seqRgb.size(); ++i) {
            float[] c = seqRgb.get(i);
            color[0] = (color[0] + c[0]) / 2.0f;
            color[1] = (color[1] + c[1]) / 2.0f;
            color[2] = (color[2] + c[2]) / 2.0f;
        }
        return color;
    }

    public static double euclidean(float[] a, float[] b) {
        double dx = a[0] - b[0];
        double dy = a[1] - b[1];
        double dz = a[2] - b[2];
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double[] weightsForLength(int glassHeight) {
        double denom = Math.pow(2.0, glassHeight - 1);
        double[] w = new double[glassHeight];
        for (int i = 0; i < glassHeight; ++i) {
            w[i] = i == 0 ? 1.0 / denom : Math.pow(2.0, i - 1) / denom;
        }
        return w;
    }

    public static List<float[]> gradient(float[] startRgb, float[] endRgb, int numSteps) {
        ArrayList<float[]> steps = new ArrayList<float[]>();
        if (numSteps <= 1) {
            steps.add(startRgb);
            return steps;
        }
        for (int i = 0; i < numSteps; ++i) {
            float t = (float)i / (float)(numSteps - 1);
            float r = startRgb[0] + (endRgb[0] - startRgb[0]) * t;
            float g = startRgb[1] + (endRgb[1] - startRgb[1]) * t;
            float b = startRgb[2] + (endRgb[2] - startRgb[2]) * t;
            steps.add(new float[]{r, g, b});
        }
        return steps;
    }

    public static BeamResult beamSearchBestSeq(float[] targetRgb, Map<String, float[]> palette, int glassHeight, int beamWidth) {
        ArrayList<String> names = new ArrayList<String>(palette.keySet());
        List rgbList = names.stream().map(palette::get).collect(Collectors.toList());
        double[] weights = ColorUtils.weightsForLength(glassHeight);
        int[] positions = new int[glassHeight];
        for (int d = 0; d < glassHeight; ++d) {
            positions[d] = glassHeight - 1 - d;
        }
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        candidates.add(new Candidate(new ArrayList<String>(), new double[]{0.0, 0.0, 0.0}));
        for (int depth = 0; depth < glassHeight; ++depth) {
            int pos = positions[depth];
            double wpos = weights[pos];
            double wRemAfterTemplate = pos > 0 ? Arrays.stream(Arrays.copyOfRange(weights, 0, pos)).sum() : 0.0;
            ArrayList<CandidateFull> newCandidates = new ArrayList<CandidateFull>();
            for (Candidate c : candidates) {
                for (int idx = 0; idx < names.size(); ++idx) {
                    String name = (String)names.get(idx);
                    float[] cRgb = (float[])rgbList.get(idx);
                    double[] newS = new double[]{c.assigned[0] + wpos * (double)cRgb[0], c.assigned[1] + wpos * (double)cRgb[1], c.assigned[2] + wpos * (double)cRgb[2]};
                    double bestEst = Double.POSITIVE_INFINITY;
                    for (float[] pRgb : rgbList) {
                        double[] dArray = new double[]{newS[0] + wRemAfterTemplate * (double)pRgb[0], newS[1] + wRemAfterTemplate * (double)pRgb[1], newS[2] + wRemAfterTemplate * (double)pRgb[2]};
                        double[] hypot = dArray;
                        double d = Math.sqrt(Math.pow(hypot[0] - (double)targetRgb[0], 2.0) + Math.pow(hypot[1] - (double)targetRgb[1], 2.0) + Math.pow(hypot[2] - (double)targetRgb[2], 2.0));
                        if (!(d < bestEst)) continue;
                        bestEst = d;
                    }
                    ArrayList<String> newSeq = new ArrayList<String>(c.seqTop);
                    newSeq.add(name);
                    newCandidates.add(new CandidateFull(newSeq, newS, bestEst));
                }
            }
            newCandidates.sort(Comparator.comparingDouble(cf -> cf.est));
            ArrayList<Candidate> next = new ArrayList<Candidate>();
            int keep = Math.min(beamWidth, newCandidates.size());
            for (int i = 0; i < keep; ++i) {
                CandidateFull cf2 = (CandidateFull)newCandidates.get(i);
                next.add(new Candidate(cf2.seqTop, cf2.assigned));
            }
            candidates = next;
        }
        double bestErr = Double.POSITIVE_INFINITY;
        ArrayList<String> bestSeq = new ArrayList<String>();
        float[] bestRgb = new float[]{0.0f, 0.0f, 0.0f};
        for (Candidate c : candidates) {
            ArrayList<String> seqBottom = new ArrayList<String>(c.seqTop);
            Collections.reverse(seqBottom);
            List<float[]> seqRgbs = seqBottom.stream().map(palette::get).collect(Collectors.toList());
            float[] mixed = ColorUtils.seqMixToColor(seqRgbs);
            double err = ColorUtils.euclidean(mixed, targetRgb);
            if (!(err < bestErr)) continue;
            bestErr = err;
            bestSeq = seqBottom;
            bestRgb = mixed;
        }
        return new BeamResult(bestSeq, bestRgb, bestErr);
    }

    public static FindResult findBestForTarget(float[] targetRgb, Map<String, float[]> palette, int maxStack, int beamWidth) {
        double overallErr = Double.POSITIVE_INFINITY;
        List<String> overallBest = new ArrayList<String>();
        float[] overallRgb = new float[]{0.0f, 0.0f, 0.0f};
        int overallLen = 0;
        for (int m = 1; m <= maxStack; ++m) {
            BeamResult br = ColorUtils.beamSearchBestSeq(targetRgb, palette, m, beamWidth);
            if (!(br.error < overallErr)) continue;
            overallErr = br.error;
            overallBest = br.sequence;
            overallRgb = br.rgb;
            overallLen = m;
        }
        return new FindResult(overallBest, overallRgb, overallErr, overallLen);
    }

    public static void runAndSendToPlayer(String startInput, String endInput, int beacons, int maxStack, int beamWidth) {
        BeaconGradient.sendToPlayer((class_2561)class_2561.method_43470((String)"beacon_gradient: Computing gradient and best glass stacks..."));
        float[] startRgb = ColorUtils.parseColorInput(startInput);
        float[] endRgb = ColorUtils.parseColorInput(endInput);
        List<float[]> steps = ColorUtils.gradient(startRgb, endRgb, beacons);
        int stepIndex = 1;
        for (float[] target : steps) {
            FindResult fr = ColorUtils.findBestForTarget(target, PALETTE, maxStack, beamWidth);
            class_5250 message = class_2561.method_43470((String)String.format("Step %2d:", stepIndex)).method_10852((class_2561)class_2561.method_43470((String)" \ntarget ")).method_10852((class_2561)BeaconGradient.colorSwatch(target)).method_10852((class_2561)class_2561.method_43470((String)"  achieved ")).method_10852((class_2561)BeaconGradient.colorSwatch(fr.rgb)).method_10852((class_2561)class_2561.method_43470((String)String.format("  \nerror=%.4f  stack_len=%d", fr.error, fr.length)));
            BeaconGradient.sendToPlayer((class_2561)message);
            class_5250 comboText = class_2561.method_43470((String)"");
            for (int i = 0; i < fr.sequence.size(); ++i) {
                String dyeName = fr.sequence.get(i);
                float[] rgb = PALETTE.get(dyeName);
                int r = Math.max(0, Math.min(255, Math.round(rgb[0] * 255.0f)));
                int g = Math.max(0, Math.min(255, Math.round(rgb[1] * 255.0f)));
                int b = Math.max(0, Math.min(255, Math.round(rgb[2] * 255.0f)));
                int color = r << 16 | g << 8 | b;
                class_5250 coloredName = class_2561.method_43470((String)dyeName).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)color)));
                comboText.method_10852((class_2561)coloredName);
                if (i >= fr.sequence.size() - 1) continue;
                comboText.method_10852((class_2561)class_2561.method_43470((String)" | "));
            }
            BeaconGradient.sendToPlayer((class_2561)class_2561.method_43470((String)"  Place bottom->top: ").method_10852((class_2561)comboText));
            ++stepIndex;
        }
    }

    static {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("white", "#F9FFFE");
        map.put("orange", "#F9801D");
        map.put("magenta", "#C74EBD");
        map.put("light_blue", "#3AB3DA");
        map.put("yellow", "#FED83D");
        map.put("lime", "#80C71F");
        map.put("pink", "#F38BAA");
        map.put("gray", "#474F52");
        map.put("light_gray", "#9D9D97");
        map.put("cyan", "#169C9C");
        map.put("purple", "#8932B8");
        map.put("blue", "#3C44AA");
        map.put("brown", "#835432");
        map.put("green", "#5E7C16");
        map.put("red", "#B02E26");
        map.put("black", "#1D1D21");
        DYE_HEX = map;
        LinkedHashMap<String, float[]> pal = new LinkedHashMap<String, float[]>();
        for (Map.Entry<String, String> e : DYE_HEX.entrySet()) {
            pal.put(e.getKey(), ColorUtils.hexToRgb(e.getValue()));
        }
        PALETTE = pal;
    }

    private static class Candidate {
        public final List<String> seqTop;
        public final double[] assigned;

        public Candidate(List<String> seqTop, double[] assigned) {
            this.seqTop = seqTop;
            this.assigned = assigned;
        }
    }

    private static class CandidateFull {
        public final List<String> seqTop;
        public final double[] assigned;
        public final double est;

        public CandidateFull(List<String> seqTop, double[] assigned, double est) {
            this.seqTop = seqTop;
            this.assigned = assigned;
            this.est = est;
        }
    }

    public static class BeamResult {
        public final List<String> sequence;
        public final float[] rgb;
        public final double error;

        public BeamResult(List<String> seq, float[] rgb, double err) {
            this.sequence = seq;
            this.rgb = rgb;
            this.error = err;
        }
    }

    public static class FindResult {
        public final List<String> sequence;
        public final float[] rgb;
        public final double error;
        public final int length;

        public FindResult(List<String> sequence, float[] rgb, double error, int length) {
            this.sequence = sequence;
            this.rgb = rgb;
            this.error = error;
            this.length = length;
        }
    }
}

