/*
 * Decompiled with CFR 0.152.
 */
package f1nal.essentials;

import com.mojang.brigadier.CommandDispatcher;
import f1nal.essentials.command.BackCommand;
import f1nal.essentials.command.DisposalCommand;
import f1nal.essentials.command.FeedCommand;
import f1nal.essentials.command.FlightCommand;
import f1nal.essentials.command.HealCommand;
import f1nal.essentials.command.RepairCommand;
import f1nal.essentials.command.TpaCommands;
import f1nal.essentials.config.CommandConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Essentials
implements ModInitializer {
    public static final String MOD_ID = "essentials";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"essentials");

    public void onInitialize() {
        this.copyDefaultConfigIfMissing();
        this.registerCommands();
        LOGGER.info("Essentials initialized");
    }

    private void registerCommands() {
        CommandConfig.CommandSettings backSettings;
        CommandConfig.CommandSettings tpaSettings;
        CommandConfig.CommandSettings disposalSettings;
        CommandConfig.CommandSettings flightSettings;
        CommandConfig.CommandSettings feedSettings;
        CommandConfig.CommandSettings healSettings;
        Map<String, CommandConfig.CommandSettings> commandSettings = CommandConfig.loadCommandSettings();
        CommandConfig.CommandSettings repairSettings = commandSettings.get("repair");
        if (repairSettings.enabled()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> RepairCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment, repairSettings));
        }
        if ((healSettings = commandSettings.get("heal")).enabled()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> HealCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment, healSettings));
        }
        if ((feedSettings = commandSettings.get("feed")).enabled()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> FeedCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment, feedSettings));
        }
        if ((flightSettings = commandSettings.get("flight")).enabled()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> FlightCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment, flightSettings));
        }
        if ((disposalSettings = commandSettings.get("disposal")).enabled()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> DisposalCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment, disposalSettings));
        }
        if ((tpaSettings = commandSettings.get("tpa")) != null && tpaSettings.enabled()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> TpaCommands.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment, tpaSettings));
        }
        if ((backSettings = commandSettings.get("back")) != null && backSettings.enabled()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> BackCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment, backSettings));
        }
    }

    private void copyDefaultConfigIfMissing() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path target = configDir.resolve("essentials.yaml");
        if (Files.exists(target, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
            try (InputStream in = Essentials.class.getClassLoader().getResourceAsStream("essentials.default.yaml");){
                if (in == null) {
                    LOGGER.warn("Missing bundled essentials.default.yaml resource; skipping config copy.");
                    return;
                }
                Files.copy(in, target, new CopyOption[0]);
                LOGGER.info("Wrote default config to {}", (Object)target.toAbsolutePath());
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write default config: {}", (Object)e.toString());
        }
    }
}

